/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NetworkNode;
import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class NetworkController
extends NetworkObject {
    private static final String CRAYON = "crayon";
    private static final Map<Location, NetworkRoot> NETWORKS = new HashMap<Location, NetworkRoot>();
    private static final Set<Location> CRAYONS = new HashSet<Location>();
    private final ItemSetting<Integer> maxNodes;
    protected final Map<Location, Boolean> firstTickMap = new HashMap<Location, Boolean>();

    public NetworkController(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.CONTROLLER);
        this.maxNodes = new IntRangeSetting((SlimefunItem)this, "max_nodes", 10, 2000, 5000);
        this.addItemSetting(new ItemSetting[]{this.maxNodes});
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block block, SlimefunItem item, Config data) {
                boolean crayon;
                if (!NetworkController.this.firstTickMap.containsKey(block.getLocation())) {
                    NetworkController.this.onFirstTick(block, data);
                    NetworkController.this.firstTickMap.put(block.getLocation(), true);
                }
                NetworkController.this.addToRegistry(block);
                NetworkRoot networkRoot = new NetworkRoot(block.getLocation(), NodeType.CONTROLLER, (Integer)NetworkController.this.maxNodes.getValue());
                networkRoot.addAllChildren();
                NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(block.getLocation());
                if (definition != null) {
                    definition.setNode(networkRoot);
                }
                if (crayon = CRAYONS.contains(block.getLocation())) {
                    networkRoot.setDisplayParticles(true);
                }
                NETWORKS.put(block.getLocation(), networkRoot);
            }
        }});
    }

    @Override
    protected void prePlace(@Nonnull PlayerRightClickEvent event) {
        Optional blockOptional = event.getClickedBlock();
        if (blockOptional.isPresent()) {
            Block block = (Block)blockOptional.get();
            Block target = block.getRelative(event.getClickedFace());
            for (BlockFace checkFace : CHECK_FACES) {
                Block checkBlock = target.getRelative(checkFace);
                SlimefunItem slimefunItem = BlockStorage.check((Block)checkBlock);
                if (slimefunItem instanceof NetworkController) {
                    this.cancelPlace(event);
                    return;
                }
                NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(checkBlock.getLocation());
                if (definition == null || definition.getNode() == null) continue;
                this.cancelPlace(event);
                return;
            }
        }
    }

    @Override
    protected void cancelPlace(PlayerRightClickEvent event) {
        event.getPlayer().sendMessage(Theme.ERROR.getColor() + "This network already has a controller!");
        event.cancel();
    }

    private void onFirstTick(@Nonnull Block block, @Nonnull Config data) {
        String crayon = data.getString(CRAYON);
        if (Boolean.parseBoolean(crayon)) {
            CRAYONS.add(block.getLocation());
        }
    }

    public static Map<Location, NetworkRoot> getNetworks() {
        return NETWORKS;
    }

    public static Set<Location> getCrayons() {
        return CRAYONS;
    }

    public static void addCrayon(@Nonnull Location location) {
        BlockStorage.addBlockInfo((Location)location, (String)CRAYON, (String)String.valueOf(true));
        CRAYONS.add(location);
    }

    public static void removeCrayon(@Nonnull Location location) {
        BlockStorage.addBlockInfo((Location)location, (String)CRAYON, null);
        CRAYONS.remove(location);
    }

    public static boolean hasCrayon(@Nonnull Location location) {
        return CRAYONS.contains(location);
    }

    public static void wipeNetwork(@Nonnull Location location) {
        NetworkRoot networkRoot = NETWORKS.remove(location);
        if (networkRoot != null) {
            for (NetworkNode node : networkRoot.getChildrenNodes()) {
                NetworkStorage.removeNode(node.getNodePosition());
            }
        }
    }
}

