/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.tools;

import de.jeff_media.morepersistentdatatypes.DataType;
import io.github.sefiraat.networks.slimefun.network.NetworkDirectional;
import io.github.sefiraat.networks.utils.Keys;
import io.github.sefiraat.networks.utils.NetworkUtils;
import io.github.sefiraat.networks.utils.StackUtils;
import io.github.sefiraat.networks.utils.Theme;
import io.github.sefiraat.networks.utils.datatypes.DataTypeMethods;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class NetworkConfigurator
extends SlimefunItem {
    public NetworkConfigurator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{new ItemUseHandler(){

            public void onRightClick(PlayerRightClickEvent e) {
                Player player = e.getPlayer();
                Optional optional = e.getClickedBlock();
                if (optional.isPresent()) {
                    SlimefunItem slimefunItem;
                    Block block = (Block)optional.get();
                    SlimefunItem slimefunItem2 = BlockStorage.check((Block)block);
                    if (Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block, Interaction.INTERACT_BLOCK) && (slimefunItem = slimefunItem2) instanceof NetworkDirectional) {
                        NetworkDirectional directional = (NetworkDirectional)slimefunItem;
                        BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
                        if (player.isSneaking()) {
                            NetworkConfigurator.this.setConfigurator(directional, e.getItem(), blockMenu, player);
                        } else {
                            NetworkUtils.applyConfig(directional, e.getItem(), blockMenu, player);
                        }
                    } else {
                        player.sendMessage(Theme.ERROR + "Must target a directional Networks interface.");
                    }
                }
                e.cancel();
            }
        }});
    }

    private void setConfigurator(@Nonnull NetworkDirectional directional, @Nonnull ItemStack itemStack, @Nonnull BlockMenu blockMenu, @Nonnull Player player) {
        BlockFace blockFace = NetworkDirectional.getSelectedFace(blockMenu.getLocation());
        if (blockFace == null) {
            player.sendMessage(Theme.ERROR + "This directional does not yet have a direction set");
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (directional.getItemSlots().length > 0) {
            ItemStack[] itemStacks = new ItemStack[directional.getItemSlots().length];
            int i = 0;
            for (int slot : directional.getItemSlots()) {
                ItemStack possibleStack = blockMenu.getItemInSlot(slot);
                if (possibleStack != null) {
                    itemStacks[i] = StackUtils.getAsQuantity(blockMenu.getItemInSlot(slot), 1);
                }
                ++i;
            }
            DataTypeMethods.setCustom((PersistentDataHolder)itemMeta, Keys.ITEM, DataType.ITEM_STACK_ARRAY, itemStacks);
        } else {
            PersistentDataAPI.remove((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.ITEM);
        }
        DataTypeMethods.setCustom((PersistentDataHolder)itemMeta, Keys.FACE, DataType.STRING, blockFace.name());
        itemStack.setItemMeta(itemMeta);
        player.sendMessage(Theme.SUCCESS + "Configuration copied.");
    }
}

