/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.tools;

import io.github.sefiraat.networks.network.stackcaches.CardInstance;
import io.github.sefiraat.networks.utils.Keys;
import io.github.sefiraat.networks.utils.Theme;
import io.github.sefiraat.networks.utils.datatypes.DataTypeMethods;
import io.github.sefiraat.networks.utils.datatypes.PersistentCardInstanceType;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import javax.annotation.Nonnull;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class NetworkCard
extends SlimefunItem {
    private static final int[] SIZES = new int[]{4096, 32768, 262144, 0x200000, 0x1000000, 0x8000000, 0x40000000, Integer.MAX_VALUE};
    private final int size;

    public NetworkCard(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int size) {
        super(itemGroup, item, recipeType, recipe);
        this.size = size;
        this.addItemHandler(new ItemHandler[]{new ItemUseHandler(){

            public void onRightClick(PlayerRightClickEvent e) {
                Player player = e.getPlayer();
                ItemStack card = player.getInventory().getItemInMainHand();
                ItemStack stackToSet = player.getInventory().getItemInOffHand().clone();
                e.cancel();
                if (card.getAmount() > 1) {
                    player.sendMessage(Theme.WARNING + "Unstack cards before assigning an item.");
                    return;
                }
                if (NetworkCard.this.isBlacklisted(stackToSet)) {
                    player.sendMessage(Theme.WARNING + "This type of item cannot be stored in a Network Card.");
                    return;
                }
                SlimefunItem cardItem = SlimefunItem.getByItem((ItemStack)card);
                SlimefunItem slimefunItem = cardItem;
                if (slimefunItem instanceof NetworkCard) {
                    NetworkCard networkCard = (NetworkCard)slimefunItem;
                    ItemMeta cardMeta = card.getItemMeta();
                    CardInstance cardInstance = DataTypeMethods.getCustom((PersistentDataHolder)cardMeta, Keys.CARD_INSTANCE, PersistentCardInstanceType.TYPE, new CardInstance(null, 0, networkCard.getSize()));
                    if (cardInstance.getAmount() > 0) {
                        e.getPlayer().sendMessage(Theme.WARNING + "A card must be empty before trying to assign an item.");
                        return;
                    }
                    cardInstance.setItemStack(stackToSet);
                    DataTypeMethods.setCustom((PersistentDataHolder)cardMeta, Keys.CARD_INSTANCE, PersistentCardInstanceType.TYPE, cardInstance);
                    cardInstance.updateLore(cardMeta);
                    card.setItemMeta(cardMeta);
                }
            }
        }});
    }

    private boolean isBlacklisted(@Nonnull ItemStack itemStack) {
        return itemStack.getType() == Material.AIR || itemStack.getType().getMaxDurability() < 0 || Tag.SHULKER_BOXES.isTagged((Keyed)itemStack.getType());
    }

    public int getSize() {
        return this.size;
    }

    public static int[] getSizes() {
        return SIZES;
    }
}

