/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.network.NetworkDirectional;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class NetworkGrabber
extends NetworkDirectional {
    public NetworkGrabber(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.GRABBER);
    }

    @Override
    protected void onTick(@Nullable BlockMenu blockMenu, @Nonnull Block block) {
        super.onTick(blockMenu, block);
        if (blockMenu != null) {
            this.tryGrabItem(blockMenu);
        }
    }

    private void tryGrabItem(@Nonnull BlockMenu blockMenu) {
        int[] slots;
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
        if (definition == null || definition.getNode() == null) {
            return;
        }
        BlockFace direction = this.getCurrentDirection(blockMenu);
        BlockMenu targetMenu = BlockStorage.getInventory((Block)blockMenu.getBlock().getRelative(direction));
        if (targetMenu == null) {
            return;
        }
        for (int slot : slots = targetMenu.getPreset().getSlotsAccessedByItemTransport((DirtyChestMenu)targetMenu, ItemTransportFlow.WITHDRAW, null)) {
            ItemStack itemStack = targetMenu.getItemInSlot(slot);
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            int before = itemStack.getAmount();
            definition.getNode().getRoot().addItemStack(itemStack);
            if (!definition.getNode().getRoot().isDisplayParticles() || itemStack.getAmount() >= before) break;
            this.showParticle(blockMenu.getLocation(), direction);
            break;
        }
    }

    @Override
    protected Particle.DustOptions getDustOptions() {
        return new Particle.DustOptions(Color.FUCHSIA, 1.0f);
    }
}

