/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.morepersistentdatatypes.implementation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.charset.Charset;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class ShortArrayDataType
implements PersistentDataType<byte[], short[]> {
    private Charset charset;

    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<short[]> getComplexType() {
        return short[].class;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte @NotNull [] toPrimitive(short[] shorts, @NotNull PersistentDataAdapterContext itemTagAdapterContext) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeInt(shorts.length);
                for (short number : shorts) {
                    dos.writeShort(number);
                }
                dos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public short @NotNull [] fromPrimitive(byte @NotNull [] bytes, @NotNull PersistentDataAdapterContext itemTagAdapterContext) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            short[] sArray;
            try (DataInputStream dis = new DataInputStream(bis);){
                short[] shorts = new short[dis.readInt()];
                for (int i = 0; i < shorts.length; ++i) {
                    shorts[i] = dis.readShort();
                }
                sArray = shorts;
            }
            return sArray;
        }
    }
}

