/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network.grid;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.GridItemRequest;
import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.sefiraat.networks.slimefun.network.grid.GridCache;
import io.github.sefiraat.networks.utils.StackUtils;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AbstractGrid
extends NetworkObject {
    private static final CustomItemStack BLANK_SLOT_STACK = new CustomItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE, " ", new String[0]);
    private static final CustomItemStack PAGE_PREVIOUS_STACK = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, Theme.CLICK_INFO.getColor() + "Previous Page", new String[0]);
    private static final CustomItemStack PAGE_NEXT_STACK = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, Theme.CLICK_INFO.getColor() + "Next Page", new String[0]);
    private static final CustomItemStack CHANGE_SORT_STACK = new CustomItemStack(Material.BLUE_STAINED_GLASS_PANE, Theme.CLICK_INFO.getColor() + "Change Sort Order", new String[0]);
    private static final CustomItemStack FILTER_STACK = new CustomItemStack(Material.NAME_TAG, Theme.CLICK_INFO.getColor() + "Set Filter (Right Click to Clear)", new String[0]);
    private static final Comparator<Map.Entry<ItemStack, Integer>> ALPHABETICAL_SORT = Comparator.comparing(itemStackIntegerEntry -> {
        ItemStack itemStack = (ItemStack)itemStackIntegerEntry.getKey();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
        if (slimefunItem != null) {
            return ChatColor.stripColor((String)slimefunItem.getItemName());
        }
        ItemMeta itemMeta = ((ItemStack)itemStackIntegerEntry.getKey()).getItemMeta();
        return itemMeta.hasDisplayName() ? ChatColor.stripColor((String)itemMeta.getDisplayName()) : ((ItemStack)itemStackIntegerEntry.getKey()).getType().name();
    });
    private static final Comparator<Map.Entry<ItemStack, Integer>> NUMERICAL_SORT = Map.Entry.comparingByValue();
    private final ItemSetting<Integer> tickRate;

    protected AbstractGrid(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.GRID);
        this.getSlotsToDrop().add(this.getInputSlot());
        this.tickRate = new IntRangeSetting((SlimefunItem)this, "tick_rate", 1, 1, 10);
        this.addItemSetting(new ItemSetting[]{this.tickRate});
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){
            private int tick = 1;

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block block, SlimefunItem item, Config data) {
                if (this.tick <= 1) {
                    BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
                    AbstractGrid.this.addToRegistry(block);
                    AbstractGrid.this.tryAddItem(blockMenu);
                    AbstractGrid.this.updateDisplay(blockMenu);
                }
            }

            public void uniqueTick() {
                this.tick = this.tick <= 1 ? (Integer)AbstractGrid.this.tickRate.getValue() : this.tick - 1;
            }
        }});
    }

    protected void tryAddItem(@Nonnull BlockMenu blockMenu) {
        ItemStack itemStack = blockMenu.getItemInSlot(this.getInputSlot());
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
        if (definition.getNode() == null) {
            return;
        }
        definition.getNode().getRoot().addItemStack(itemStack);
    }

    protected void updateDisplay(@Nonnull BlockMenu blockMenu) {
        if (!blockMenu.hasViewer()) {
            return;
        }
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
        if (definition == null || definition.getNode() == null) {
            this.clearDisplay(blockMenu);
            return;
        }
        NetworkRoot root = definition.getNode().getRoot();
        GridCache gridCache = this.getCacheMap().get(blockMenu.getLocation().clone());
        List<Map.Entry<ItemStack, Integer>> entries = this.getEntries(root, gridCache);
        int pages = (int)Math.ceil((double)entries.size() / (double)this.getDisplaySlots().length) - 1;
        gridCache.setMaxPages(pages);
        if (pages < 0) {
            this.clearDisplay(blockMenu);
            return;
        }
        if (gridCache.getPage() > pages) {
            gridCache.setPage(0);
        }
        int start = gridCache.getPage() * this.getDisplaySlots().length;
        int end = Math.min(start + this.getDisplaySlots().length, entries.size());
        List<Map.Entry<ItemStack, Integer>> validEntries = entries.subList(start, end);
        this.getCacheMap().put(blockMenu.getLocation(), gridCache);
        for (int i = 0; i < this.getDisplaySlots().length; ++i) {
            if (validEntries.size() > i) {
                Map.Entry<ItemStack, Integer> entry = validEntries.get(i);
                ItemStack displayStack = entry.getKey().clone();
                ItemMeta itemMeta = displayStack.getItemMeta();
                List<String> lore = itemMeta.getLore();
                if (lore == null) {
                    lore = AbstractGrid.getLoreAddition(entry.getValue());
                } else {
                    lore.addAll(AbstractGrid.getLoreAddition(entry.getValue()));
                }
                itemMeta.setLore(lore);
                displayStack.setItemMeta(itemMeta);
                blockMenu.replaceExistingItem(this.getDisplaySlots()[i], displayStack);
                blockMenu.addMenuClickHandler(this.getDisplaySlots()[i], (player, slot, item, action) -> {
                    this.retrieveItem(player, definition, item, action, blockMenu);
                    return false;
                });
                continue;
            }
            blockMenu.replaceExistingItem(this.getDisplaySlots()[i], (ItemStack)BLANK_SLOT_STACK);
            blockMenu.addMenuClickHandler(this.getDisplaySlots()[i], (p, slot, item, action) -> false);
        }
    }

    protected void clearDisplay(BlockMenu blockMenu) {
        for (int displaySlot : this.getDisplaySlots()) {
            blockMenu.replaceExistingItem(displaySlot, (ItemStack)BLANK_SLOT_STACK);
            blockMenu.addMenuClickHandler(displaySlot, (p, slot, item, action) -> false);
        }
    }

    @Nonnull
    protected List<Map.Entry<ItemStack, Integer>> getEntries(@Nonnull NetworkRoot networkRoot, @Nonnull GridCache cache) {
        return networkRoot.getAllNetworkItems().entrySet().stream().filter(entry -> {
            ItemMeta itemMeta;
            if (cache.getFilter() == null) {
                return true;
            }
            ItemStack itemStack = (ItemStack)entry.getKey();
            String name = itemStack.getType().name().toLowerCase(Locale.ROOT);
            if (itemStack.hasItemMeta() && (itemMeta = itemStack.getItemMeta()).hasDisplayName()) {
                name = ChatColor.stripColor((String)itemMeta.getDisplayName().toLowerCase(Locale.ROOT));
            }
            return name.contains(cache.getFilter());
        }).sorted(cache.getSortOrder() == GridCache.SortOrder.ALPHABETICAL ? ALPHABETICAL_SORT : NUMERICAL_SORT.reversed()).toList();
    }

    protected boolean setFilter(@Nonnull Player player, @Nonnull BlockMenu blockMenu, @Nonnull GridCache gridCache, @Nonnull ClickAction action) {
        if (action.isRightClicked()) {
            gridCache.setFilter(null);
        } else {
            player.closeInventory();
            player.sendMessage(Theme.WARNING + "Type what you would like to filter this grid to");
            ChatUtils.awaitInput((Player)player, s -> {
                if (s.isBlank()) {
                    return;
                }
                gridCache.setFilter(s.toLowerCase(Locale.ROOT));
                player.sendMessage(Theme.SUCCESS + "Filter applied");
            });
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    protected void retrieveItem(Player player, NodeDefinition definition, @Nullable ItemStack itemStack, ClickAction action, BlockMenu blockMenu) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        ItemStack clone = itemStack.clone();
        ItemMeta cloneMeta = clone.getItemMeta();
        List cloneLore = cloneMeta.getLore();
        cloneLore.remove(cloneLore.size() - 1);
        cloneLore.remove(cloneLore.size() - 1);
        cloneMeta.setLore(cloneLore);
        clone.setItemMeta(cloneMeta);
        int amount = 1;
        if (action.isRightClicked()) {
            amount = clone.getMaxStackSize();
        }
        GridItemRequest request = new GridItemRequest(clone, amount, player);
        if (action.isShiftClicked()) {
            this.addToInventory(player, definition, request, action);
        } else {
            this.addToCursor(player, definition, request, action);
        }
        this.updateDisplay(blockMenu);
    }

    @ParametersAreNonnullByDefault
    private void addToInventory(Player player, NodeDefinition definition, GridItemRequest request, ClickAction action) {
        ItemStack requestingStack = definition.getNode().getRoot().getItemStack(request);
        if (requestingStack == null) {
            return;
        }
        HashMap remnant = player.getInventory().addItem(new ItemStack[]{requestingStack});
        requestingStack = remnant.values().stream().findFirst().orElse(null);
        if (requestingStack != null) {
            definition.getNode().getRoot().addItemStack(requestingStack);
        }
    }

    @ParametersAreNonnullByDefault
    private void addToCursor(Player player, NodeDefinition definition, GridItemRequest request, ClickAction action) {
        ItemStack cursor = player.getItemOnCursor();
        if (cursor.getType() != Material.AIR && !this.canAddMore(action, cursor, request)) {
            return;
        }
        ItemStack requestingStack = definition.getNode().getRoot().getItemStack(request);
        this.setCursor(player, cursor, requestingStack);
    }

    private void setCursor(Player player, ItemStack cursor, ItemStack requestingStack) {
        if (requestingStack != null) {
            if (cursor.getType() != Material.AIR) {
                requestingStack.setAmount(cursor.getAmount() + 1);
            }
            player.setItemOnCursor(requestingStack);
        }
    }

    private boolean canAddMore(@Nonnull ClickAction action, @Nonnull ItemStack cursor, @Nonnull GridItemRequest request) {
        return !action.isRightClicked() && request.getAmount() == 1 && cursor.getAmount() < cursor.getMaxStackSize() && StackUtils.itemsMatch(request, cursor, true);
    }

    public void postRegister() {
        this.getPreset();
    }

    @Nonnull
    protected abstract BlockMenuPreset getPreset();

    @Nonnull
    protected abstract Map<Location, GridCache> getCacheMap();

    protected abstract int[] getBackgroundSlots();

    protected abstract int[] getDisplaySlots();

    protected abstract int getInputSlot();

    protected abstract int getChangeSort();

    protected abstract int getPagePrevious();

    protected abstract int getPageNext();

    protected abstract int getFilterSlot();

    protected CustomItemStack getBlankSlotStack() {
        return BLANK_SLOT_STACK;
    }

    protected CustomItemStack getPagePreviousStack() {
        return PAGE_PREVIOUS_STACK;
    }

    protected CustomItemStack getPageNextStack() {
        return PAGE_NEXT_STACK;
    }

    protected CustomItemStack getChangeSortStack() {
        return CHANGE_SORT_STACK;
    }

    protected CustomItemStack getFilterStack() {
        return FILTER_STACK;
    }

    @Nonnull
    private static List<String> getLoreAddition(int amount) {
        MessageFormat format = new MessageFormat("{0}Amount: {1}{2}", Locale.ROOT);
        return List.of("", format.format(new Object[]{Theme.CLICK_INFO.getColor(), Theme.PASSIVE.getColor(), amount}, new StringBuffer(), (FieldPosition)null).toString());
    }
}

