/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import dev.sefiraat.sefilib.misc.ParticleUtils;
import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.Networks;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.NetworkSlimefunItems;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class NetworkVacuum
extends NetworkObject {
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private final ItemSetting<Integer> tickRate = new IntRangeSetting((SlimefunItem)this, "tick_rate", 1, 1, 10);
    private final ItemSetting<Integer> vacuumRange = new IntRangeSetting((SlimefunItem)this, "vacuum_range", 1, 2, 5);

    public NetworkVacuum(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.VACUUM);
        this.addItemSetting(new ItemSetting[]{this.tickRate, this.vacuumRange});
        for (int inputSlot : INPUT_SLOTS) {
            this.getSlotsToDrop().add(inputSlot);
        }
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){
            private int tick = 1;

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block block, SlimefunItem item, Config data) {
                if (this.tick <= 1) {
                    BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
                    NetworkVacuum.this.addToRegistry(block);
                    NetworkVacuum.this.tryAddItem(blockMenu);
                    Bukkit.getScheduler().runTask((Plugin)Networks.getInstance(), bukkitTask -> NetworkVacuum.this.findItem(blockMenu));
                }
            }

            public void uniqueTick() {
                this.tick = this.tick <= 1 ? (Integer)NetworkVacuum.this.tickRate.getValue() : this.tick - 1;
            }
        }});
    }

    private void findItem(@Nonnull BlockMenu blockMenu) {
        for (int inputSlot : INPUT_SLOTS) {
            Object e;
            ItemStack inSlot = blockMenu.getItemInSlot(inputSlot);
            if (inSlot != null && !inSlot.getType().isAir()) continue;
            Location location = blockMenu.getLocation().clone().add(0.5, 0.5, 0.5);
            int range = (Integer)this.vacuumRange.getValue();
            Collection items = location.getWorld().getNearbyEntities(location, (double)range, (double)range, (double)range, Item.class::isInstance);
            Optional optionalEntity = items.stream().findFirst();
            if (optionalEntity.isEmpty() || !((e = optionalEntity.get()) instanceof Item)) {
                return;
            }
            Item item = (Item)e;
            if (item.getPickupDelay() <= 0 && !SlimefunUtils.hasNoPickupFlag((Item)item)) {
                ItemStack itemStack = item.getItemStack();
                blockMenu.replaceExistingItem(inputSlot, itemStack);
                ParticleUtils.displayParticleRandomly((Entity)item, 1.0, 5, new Particle.DustOptions(Color.BLUE, 1.0f));
                item.remove();
            }
            return;
        }
    }

    private void tryAddItem(@Nonnull BlockMenu blockMenu) {
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
        if (definition.getNode() == null) {
            return;
        }
        for (int inputSlot : INPUT_SLOTS) {
            ItemStack itemStack = blockMenu.getItemInSlot(inputSlot);
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            definition.getNode().getRoot().addItemStack(itemStack);
        }
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.setSize(9);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return NetworkSlimefunItems.NETWORK_VACUUM.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return INPUT_SLOTS;
                }
                return new int[0];
            }
        };
    }
}

