/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.entity.display.builders;

import dev.sefiraat.sefilib.entity.display.DisplayGroup;
import dev.sefiraat.sefilib.entity.display.DisplayInteractable;
import dev.sefiraat.sefilib.entity.display.builders.DisplayBuilder;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;

public class BlockDisplayBuilder
extends DisplayBuilder<BlockDisplayBuilder>
implements DisplayInteractable {
    protected BlockData blockData;

    public BlockDisplayBuilder setBlockData(@Nonnull BlockData blockData) {
        this.blockData = blockData;
        return this;
    }

    public BlockDisplay build() {
        if (this.location == null) {
            throw new IllegalStateException("You must provide a Location for the Display Entity");
        }
        return this.generateDisplay(this.location);
    }

    public BlockDisplay build(@Nonnull DisplayGroup group) {
        if (this.groupParentOffset == null) {
            throw new IllegalStateException("You must provide a Group Parent Offset vector");
        }
        return this.generateDisplay(group.getLocation().clone().add(this.groupParentOffset));
    }

    private BlockDisplay generateDisplay(@Nonnull Location location) {
        if (this.blockData == null) {
            throw new IllegalStateException("you must provide a BlockData Object for this Display");
        }
        BlockDisplay display = (BlockDisplay)location.getWorld().spawnEntity(location, EntityType.BLOCK_DISPLAY);
        display.setBlock(this.blockData);
        this.applyDisplay((Display)display);
        return display;
    }
}

