/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.utils.datatypes;

import de.jeff_media.morepersistentdatatypes.DataType;
import io.github.sefiraat.networks.network.stackcaches.CardInstance;
import io.github.sefiraat.networks.utils.Keys;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PersistentAmountInstanceType
implements PersistentDataType<PersistentDataContainer, CardInstance> {
    public static final PersistentDataType<PersistentDataContainer, CardInstance> TYPE = new PersistentAmountInstanceType();
    public static final NamespacedKey ITEM = Keys.newKey("item");
    public static final NamespacedKey AMOUNT = Keys.newKey("amount");
    public static final NamespacedKey LIMIT = Keys.newKey("limit");
    public static final NamespacedKey UNSTACK = Keys.newKey("time");

    @Nonnull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @Nonnull
    public Class<CardInstance> getComplexType() {
        return CardInstance.class;
    }

    @Nonnull
    public PersistentDataContainer toPrimitive(@Nonnull CardInstance complex, @Nonnull PersistentDataAdapterContext context) {
        PersistentDataContainer container = context.newPersistentDataContainer();
        container.set(ITEM, DataType.ITEM_STACK, (Object)complex.getItemStack());
        container.set(AMOUNT, DataType.INTEGER, (Object)complex.getAmount());
        container.set(LIMIT, DataType.INTEGER, (Object)complex.getLimit());
        container.set(UNSTACK, DataType.LONG, (Object)System.currentTimeMillis());
        return container;
    }

    @Nonnull
    public CardInstance fromPrimitive(@Nonnull PersistentDataContainer primitive, @Nonnull PersistentDataAdapterContext context) {
        int amount = (Integer)primitive.get(AMOUNT, DataType.INTEGER);
        int limit = (Integer)primitive.get(LIMIT, DataType.INTEGER);
        return new CardInstance(null, amount, limit);
    }
}

