/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.network.AdminDebuggable;
import io.github.sefiraat.networks.slimefun.network.NetworkController;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public abstract class NetworkObject
extends SlimefunItem
implements AdminDebuggable {
    private final NodeType nodeType;
    private final List<Integer> slotsToDrop = new ArrayList<Integer>();

    protected NetworkObject(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, NodeType type) {
        this(itemGroup, item, recipeType, recipe, null, type);
    }

    protected NetworkObject(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput, NodeType type) {
        super(itemGroup, item, recipeType, recipe, recipeOutput);
        this.nodeType = type;
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return NetworkObject.this.runSync();
            }

            public void tick(Block b, SlimefunItem item, Config data) {
                NetworkObject.this.addToRegistry(b);
            }
        }, new BlockBreakHandler(false, false){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent event, ItemStack item, List<ItemStack> drops) {
                NetworkObject.this.preBreak(event);
                NetworkObject.this.onBreak(event);
            }
        }});
    }

    protected void addToRegistry(@Nonnull Block block) {
        if (!NetworkStorage.getAllNetworkObjects().containsKey(block.getLocation())) {
            NodeDefinition nodeDefinition = new NodeDefinition(this.nodeType);
            NetworkStorage.getAllNetworkObjects().put(block.getLocation(), nodeDefinition);
        }
    }

    protected void preBreak(@Nonnull BlockBreakEvent event) {
    }

    protected void onBreak(@Nonnull BlockBreakEvent event) {
        Location location = event.getBlock().getLocation();
        BlockMenu blockMenu = BlockStorage.getInventory((Block)event.getBlock());
        if (blockMenu != null) {
            for (int i : this.slotsToDrop) {
                blockMenu.dropItems(location, new int[]{i});
            }
        }
        NetworkStorage.removeNode(location);
        if (this.nodeType == NodeType.CONTROLLER) {
            NetworkController.wipeNetwork(location);
        }
        BlockStorage.clearBlockInfo((Location)location);
    }

    public boolean runSync() {
        return false;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public List<Integer> getSlotsToDrop() {
        return this.slotsToDrop;
    }
}

