/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.network;

import io.github.mooy1.infinityexpansion.items.storage.StorageCache;
import io.github.mooy1.infinityexpansion.items.storage.StorageUnit;
import io.github.sefiraat.networks.Networks;
import io.github.sefiraat.networks.network.NetworkNode;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.network.barrel.InfinityBarrel;
import io.github.sefiraat.networks.network.barrel.NetworkStorage;
import io.github.sefiraat.networks.network.stackcaches.BarrelIdentity;
import io.github.sefiraat.networks.network.stackcaches.ItemRequest;
import io.github.sefiraat.networks.network.stackcaches.QuantumCache;
import io.github.sefiraat.networks.slimefun.network.NetworkDirectional;
import io.github.sefiraat.networks.slimefun.network.NetworkPowerNode;
import io.github.sefiraat.networks.slimefun.network.NetworkQuantumStorage;
import io.github.sefiraat.networks.utils.StackUtils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class NetworkRoot
extends NetworkNode {
    private final Set<Location> nodeLocations = new HashSet<Location>();
    private final int maxNodes;
    private boolean isOverburdened = false;
    private final Set<Location> bridges = ConcurrentHashMap.newKeySet();
    private final Set<Location> monitors = ConcurrentHashMap.newKeySet();
    private final Set<Location> importers = ConcurrentHashMap.newKeySet();
    private final Set<Location> exporters = ConcurrentHashMap.newKeySet();
    private final Set<Location> grids = ConcurrentHashMap.newKeySet();
    private final Set<Location> cells = ConcurrentHashMap.newKeySet();
    private final Set<Location> wipers = ConcurrentHashMap.newKeySet();
    private final Set<Location> grabbers = ConcurrentHashMap.newKeySet();
    private final Set<Location> pushers = ConcurrentHashMap.newKeySet();
    private final Set<Location> purgers = ConcurrentHashMap.newKeySet();
    private final Set<Location> crafters = ConcurrentHashMap.newKeySet();
    private final Set<Location> powerNodes = ConcurrentHashMap.newKeySet();
    private final Set<Location> powerDisplays = ConcurrentHashMap.newKeySet();
    private final Set<Location> encoders = ConcurrentHashMap.newKeySet();
    private final Set<Location> greedyBlocks = ConcurrentHashMap.newKeySet();
    private Set<BarrelIdentity> barrels = null;
    private long rootPower = 0L;
    private boolean displayParticles = false;

    public NetworkRoot(@Nonnull Location location, @Nonnull NodeType type, int maxNodes) {
        super(location, type);
        this.maxNodes = maxNodes;
        this.root = this;
    }

    public void registerNode(@Nonnull Location location, @Nonnull NodeType type) {
        this.nodeLocations.add(location);
        switch (type) {
            case CONTROLLER: {
                break;
            }
            case BRIDGE: {
                this.bridges.add(location);
                break;
            }
            case STORAGE_MONITOR: {
                this.monitors.add(location);
                break;
            }
            case IMPORT: {
                this.importers.add(location);
                break;
            }
            case EXPORT: {
                this.exporters.add(location);
                break;
            }
            case GRID: {
                this.grids.add(location);
                break;
            }
            case CELL: {
                this.cells.add(location);
                break;
            }
            case WIPER: {
                this.wipers.add(location);
                break;
            }
            case GRABBER: {
                this.grabbers.add(location);
                break;
            }
            case PUSHER: {
                this.pushers.add(location);
                break;
            }
            case PURGER: {
                this.purgers.add(location);
                break;
            }
            case CRAFTER: {
                this.crafters.add(location);
                break;
            }
            case POWER_NODE: {
                this.powerNodes.add(location);
                break;
            }
            case POWER_DISPLAY: {
                this.powerDisplays.add(location);
                break;
            }
            case ENCODER: {
                this.encoders.add(location);
                break;
            }
            case GREEDY_BLOCK: {
                this.greedyBlocks.add(location);
            }
        }
    }

    public Set<Location> getNodeLocations() {
        return this.nodeLocations;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public int getNodeCount() {
        return this.nodeLocations.size();
    }

    public boolean isOverburdened() {
        return this.isOverburdened;
    }

    public void setOverburdened(boolean overburdened) {
        if (overburdened && !this.isOverburdened) {
            Location loc = this.nodePosition.clone();
            for (int x = 0; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = 0; z <= 1; ++z) {
                        loc.getWorld().spawnParticle(Particle.EXPLOSION_NORMAL, loc.clone().add((double)x, (double)y, (double)z), 0);
                    }
                }
            }
        }
        this.isOverburdened = overburdened;
    }

    public Set<Location> getBridges() {
        return this.bridges;
    }

    public Set<Location> getMonitors() {
        return this.monitors;
    }

    public Set<Location> getImporters() {
        return this.importers;
    }

    public Set<Location> getExporters() {
        return this.exporters;
    }

    public Set<Location> getGrids() {
        return this.grids;
    }

    public Set<Location> getCells() {
        return this.cells;
    }

    public Set<Location> getWipers() {
        return this.wipers;
    }

    public Set<Location> getGrabbers() {
        return this.grabbers;
    }

    public Set<Location> getPushers() {
        return this.pushers;
    }

    public Set<Location> getPurgers() {
        return this.purgers;
    }

    public Set<Location> getCrafters() {
        return this.crafters;
    }

    public Set<Location> getPowerNodes() {
        return this.powerNodes;
    }

    public Set<Location> getPowerDisplays() {
        return this.powerDisplays;
    }

    public Set<Location> getEncoders() {
        return this.encoders;
    }

    @Nonnull
    public Map<ItemStack, Integer> getAllNetworkItems() {
        HashMap<ItemStack, Integer> itemStacks = new HashMap<ItemStack, Integer>();
        for (BarrelIdentity barrelIdentity : this.getBarrels()) {
            long newLong;
            Integer currentAmount = (Integer)itemStacks.get(barrelIdentity.getItemStack());
            int newAmount = currentAmount == null ? barrelIdentity.getAmount() : ((newLong = (long)currentAmount.intValue() + (long)barrelIdentity.getAmount()) > Integer.MAX_VALUE ? Integer.MAX_VALUE : currentAmount + barrelIdentity.getAmount());
            itemStacks.put(barrelIdentity.getItemStack(), newAmount);
        }
        for (BlockMenu blockMenu : this.getGreedyBlocks()) {
            long newLong;
            ItemStack itemStack = blockMenu.getItemInSlot(16);
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            ItemStack clone = StackUtils.getAsQuantity(itemStack, 1);
            Integer currentAmount = (Integer)itemStacks.get(clone);
            int newAmount = currentAmount == null ? itemStack.getAmount() : ((newLong = (long)currentAmount.intValue() + (long)itemStack.getAmount()) > Integer.MAX_VALUE ? Integer.MAX_VALUE : currentAmount + itemStack.getAmount());
            itemStacks.put(clone, newAmount);
        }
        for (BlockMenu blockMenu : this.getCrafterOutputs()) {
            int[] slots;
            for (int slot : slots = blockMenu.getPreset().getSlotsAccessedByItemTransport(ItemTransportFlow.WITHDRAW)) {
                long newLong;
                ItemStack itemStack = blockMenu.getItemInSlot(slot);
                if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                ItemStack clone = StackUtils.getAsQuantity(itemStack, 1);
                Integer currentAmount = (Integer)itemStacks.get(clone);
                int newAmount = currentAmount == null ? itemStack.getAmount() : ((newLong = (long)currentAmount.intValue() + (long)itemStack.getAmount()) > Integer.MAX_VALUE ? Integer.MAX_VALUE : currentAmount + itemStack.getAmount());
                itemStacks.put(clone, newAmount);
            }
        }
        for (BlockMenu blockMenu : this.getCellMenus()) {
            for (ItemStack itemStack : blockMenu.getContents()) {
                long newLong;
                if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                ItemStack clone = itemStack.clone();
                clone.setAmount(1);
                Integer currentAmount = (Integer)itemStacks.get(clone);
                int newAmount = currentAmount == null ? itemStack.getAmount() : ((newLong = (long)currentAmount.intValue() + (long)itemStack.getAmount()) > Integer.MAX_VALUE ? Integer.MAX_VALUE : currentAmount + itemStack.getAmount());
                itemStacks.put(clone, newAmount);
            }
        }
        return itemStacks;
    }

    @Nonnull
    public Set<BarrelIdentity> getBarrels() {
        if (this.barrels != null) {
            return this.barrels;
        }
        ConcurrentHashMap.KeySetView addedLocations = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView<BarrelIdentity, Boolean> barrelSet = ConcurrentHashMap.newKeySet();
        for (Location cellLocation : this.monitors) {
            BlockMenu menu;
            NetworkStorage storage;
            SlimefunItem slimefunItem;
            Location testLocation;
            BlockFace face = NetworkDirectional.getSelectedFace(cellLocation);
            if (face == null || addedLocations.contains(testLocation = cellLocation.clone().add(face.getDirection()))) continue;
            addedLocations.add(testLocation);
            SlimefunItem slimefunItem2 = BlockStorage.check((Location)testLocation);
            if (Networks.getSupportedPluginManager().isInfinityExpansion() && (slimefunItem = slimefunItem2) instanceof StorageUnit) {
                StorageUnit unit = (StorageUnit)slimefunItem;
                BlockMenu menu2 = BlockStorage.getInventory((Location)testLocation);
                InfinityBarrel infinityBarrel = this.getInfinityBarrel(menu2, unit);
                if (infinityBarrel == null) continue;
                barrelSet.add(infinityBarrel);
                continue;
            }
            if (!(slimefunItem2 instanceof NetworkQuantumStorage) || (storage = this.getNetworkStorage(menu = BlockStorage.getInventory((Location)testLocation))) == null) continue;
            barrelSet.add(storage);
        }
        this.barrels = barrelSet;
        return barrelSet;
    }

    @Nullable
    private InfinityBarrel getInfinityBarrel(@Nonnull BlockMenu blockMenu, @Nonnull StorageUnit storageUnit) {
        ItemStack itemStack = blockMenu.getItemInSlot(16);
        Config config = BlockStorage.getLocationInfo((Location)blockMenu.getLocation());
        String storedString = config.getString("stored");
        if (storedString == null) {
            return null;
        }
        int storedInt = Integer.parseInt(storedString);
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        StorageCache cache = storageUnit.getCache(blockMenu.getLocation());
        if (cache == null) {
            return null;
        }
        ItemStack clone = itemStack.clone();
        clone.setAmount(1);
        return new InfinityBarrel(blockMenu.getLocation(), clone, storedInt + itemStack.getAmount(), cache);
    }

    @Nullable
    private NetworkStorage getNetworkStorage(@Nonnull BlockMenu blockMenu) {
        QuantumCache cache = NetworkQuantumStorage.getCaches().get(blockMenu.getLocation());
        if (cache == null || cache.getItemStack() == null) {
            return null;
        }
        ItemStack output = blockMenu.getItemInSlot(7);
        ItemStack itemStack = cache.getItemStack();
        int storedInt = cache.getAmount();
        if (output != null && output.getType() != Material.AIR && StackUtils.itemsMatch(cache, output, true)) {
            storedInt += output.getAmount();
        }
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        ItemStack clone = itemStack.clone();
        clone.setAmount(1);
        return new NetworkStorage(blockMenu.getLocation(), clone, storedInt);
    }

    @Nonnull
    public Set<BlockMenu> getCellMenus() {
        HashSet<BlockMenu> menus = new HashSet<BlockMenu>();
        for (Location cellLocation : this.cells) {
            BlockMenu menu = BlockStorage.getInventory((Location)cellLocation);
            if (menu == null) continue;
            menus.add(menu);
        }
        return menus;
    }

    @Nonnull
    public Set<BlockMenu> getCrafterOutputs() {
        HashSet<BlockMenu> menus = new HashSet<BlockMenu>();
        for (Location location : this.crafters) {
            BlockMenu menu = BlockStorage.getInventory((Location)location);
            if (menu == null) continue;
            menus.add(menu);
        }
        return menus;
    }

    @Nonnull
    public Set<BlockMenu> getGreedyBlocks() {
        HashSet<BlockMenu> menus = new HashSet<BlockMenu>();
        for (Location location : this.greedyBlocks) {
            BlockMenu menu = BlockStorage.getInventory((Location)location);
            if (menu == null) continue;
            menus.add(menu);
        }
        return menus;
    }

    @Nullable
    public ItemStack getItemStack(@Nonnull ItemRequest request) {
        ItemStack itemStack;
        ItemStack stackToReturn = null;
        for (BlockMenu blockMenu : this.getCellMenus()) {
            for (ItemStack itemStack2 : blockMenu.getContents()) {
                if (itemStack2 == null || itemStack2.getType() == Material.AIR || !StackUtils.itemsMatch(request, itemStack2, true)) continue;
                blockMenu.markDirty();
                if (stackToReturn == null) {
                    stackToReturn = itemStack2.clone();
                    stackToReturn.setAmount(1);
                    request.receiveAmount(1);
                    itemStack2.setAmount(itemStack2.getAmount() - 1);
                }
                if (request.getAmount() <= 0) {
                    return stackToReturn;
                }
                if (request.getAmount() <= itemStack2.getAmount()) {
                    stackToReturn.setAmount(stackToReturn.getAmount() + request.getAmount());
                    itemStack2.setAmount(itemStack2.getAmount() - request.getAmount());
                    return stackToReturn;
                }
                stackToReturn.setAmount(stackToReturn.getAmount() + itemStack2.getAmount());
                request.receiveAmount(itemStack2.getAmount());
                itemStack2.setAmount(0);
            }
        }
        for (BlockMenu blockMenu : this.getCrafterOutputs()) {
            int[] slots;
            for (int slot : slots = blockMenu.getPreset().getSlotsAccessedByItemTransport(ItemTransportFlow.WITHDRAW)) {
                ItemStack itemStack3 = blockMenu.getItemInSlot(slot);
                if (itemStack3 == null || itemStack3.getType() == Material.AIR || !StackUtils.itemsMatch(request, itemStack3, true)) continue;
                if (stackToReturn == null) {
                    stackToReturn = itemStack3.clone();
                    stackToReturn.setAmount(1);
                    request.receiveAmount(1);
                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                }
                if (request.getAmount() <= 0) {
                    return stackToReturn;
                }
                if (request.getAmount() <= itemStack3.getAmount()) {
                    stackToReturn.setAmount(stackToReturn.getAmount() + request.getAmount());
                    itemStack3.setAmount(itemStack3.getAmount() - request.getAmount());
                    return stackToReturn;
                }
                stackToReturn.setAmount(stackToReturn.getAmount() + itemStack3.getAmount());
                request.receiveAmount(itemStack3.getAmount());
                itemStack3.setAmount(0);
            }
        }
        for (BlockMenu blockMenu : this.getGreedyBlocks()) {
            itemStack = blockMenu.getItemInSlot(16);
            if (itemStack == null || itemStack.getType() == Material.AIR || !StackUtils.itemsMatch(request, itemStack, true)) continue;
            blockMenu.markDirty();
            if (stackToReturn == null) {
                stackToReturn = itemStack.clone();
                stackToReturn.setAmount(1);
                request.receiveAmount(1);
                itemStack.setAmount(itemStack.getAmount() - 1);
            }
            if (request.getAmount() <= 0) {
                return stackToReturn;
            }
            if (request.getAmount() <= itemStack.getAmount()) {
                stackToReturn.setAmount(stackToReturn.getAmount() + request.getAmount());
                itemStack.setAmount(itemStack.getAmount() - request.getAmount());
                return stackToReturn;
            }
            stackToReturn.setAmount(stackToReturn.getAmount() + itemStack.getAmount());
            request.receiveAmount(itemStack.getAmount());
            itemStack.setAmount(0);
        }
        for (BarrelIdentity barrelIdentity : this.getBarrels()) {
            int preserveAmount;
            itemStack = barrelIdentity.getItemStack();
            if (itemStack == null || !StackUtils.itemsMatch(request, itemStack, true)) continue;
            boolean infinity = barrelIdentity instanceof InfinityBarrel;
            ItemStack fetched = barrelIdentity.requestItem(request);
            if (fetched == null || fetched.getType() == Material.AIR || infinity && fetched.getAmount() == 1) continue;
            if (stackToReturn == null) {
                stackToReturn = fetched.clone();
                stackToReturn.setAmount(1);
                request.receiveAmount(1);
                fetched.setAmount(fetched.getAmount() - 1);
            }
            if (request.getAmount() <= 0) {
                return stackToReturn;
            }
            int n = preserveAmount = infinity ? fetched.getAmount() - 1 : fetched.getAmount();
            if (request.getAmount() <= preserveAmount) {
                stackToReturn.setAmount(stackToReturn.getAmount() + request.getAmount());
                fetched.setAmount(fetched.getAmount() - request.getAmount());
                return stackToReturn;
            }
            stackToReturn.setAmount(stackToReturn.getAmount() + preserveAmount);
            request.receiveAmount(preserveAmount);
            fetched.setAmount(fetched.getAmount() - preserveAmount);
        }
        return stackToReturn;
    }

    public boolean contains(@Nonnull ItemRequest[] requests) {
        for (ItemRequest request : requests) {
            if (this.contains(request)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(@Nonnull ItemRequest request) {
        ItemStack itemStack;
        int found = 0;
        for (BlockMenu blockMenu : this.getCellMenus()) {
            for (ItemStack itemStack2 : blockMenu.getContents()) {
                if (itemStack2 == null || itemStack2.getType() == Material.AIR || !StackUtils.itemsMatch(request, itemStack2, true) || (found += itemStack2.getAmount()) < request.getAmount()) continue;
                return true;
            }
        }
        for (BlockMenu blockMenu : this.getCrafterOutputs()) {
            int[] slots;
            for (int slot : slots = blockMenu.getPreset().getSlotsAccessedByItemTransport(ItemTransportFlow.WITHDRAW)) {
                ItemStack itemStack3 = blockMenu.getItemInSlot(slot);
                if (itemStack3 == null || itemStack3.getType() == Material.AIR || !StackUtils.itemsMatch(request, itemStack3, true) || (found += itemStack3.getAmount()) < request.getAmount()) continue;
                return true;
            }
        }
        for (BarrelIdentity barrelIdentity : this.getBarrels()) {
            itemStack = barrelIdentity.getItemStack();
            if (itemStack == null || !StackUtils.itemsMatch(request, itemStack, true)) continue;
            if (barrelIdentity instanceof InfinityBarrel) {
                if (barrelIdentity.getItemStack().getMaxStackSize() > 1) {
                    found += barrelIdentity.getAmount() - 2;
                }
            } else {
                found += barrelIdentity.getAmount();
            }
            if (found < request.getAmount()) continue;
            return true;
        }
        for (BlockMenu blockMenu : this.getGreedyBlocks()) {
            itemStack = blockMenu.getItemInSlot(16);
            if (itemStack == null || itemStack.getType() == Material.AIR || !StackUtils.itemsMatch(request, itemStack, true) || (found += itemStack.getAmount()) < request.getAmount()) continue;
            return true;
        }
        return false;
    }

    public void addItemStack(@Nonnull ItemStack incoming) {
        for (BlockMenu blockMenu : this.getGreedyBlocks()) {
            ItemStack template = blockMenu.getItemInSlot(10);
            if (template == null || template.getType() == Material.AIR || !StackUtils.itemsMatch(incoming, template)) continue;
            ItemStack itemStack = blockMenu.getItemInSlot(16);
            if (itemStack == null || itemStack.getType() == Material.AIR) {
                blockMenu.replaceExistingItem(16, incoming.clone());
                incoming.setAmount(0);
                return;
            }
            int itemStackAmount = itemStack.getAmount();
            int incomingStackAmount = incoming.getAmount();
            if (itemStackAmount < itemStack.getMaxStackSize() && StackUtils.itemsMatch(itemStack, incoming)) {
                int maxCanAdd = itemStack.getMaxStackSize() - itemStackAmount;
                int amountToAdd = Math.min(maxCanAdd, incomingStackAmount);
                itemStack.setAmount(itemStackAmount + amountToAdd);
                incoming.setAmount(incomingStackAmount - amountToAdd);
            }
            return;
        }
        for (BarrelIdentity barrelIdentity : this.getBarrels()) {
            if (!StackUtils.itemsMatch(barrelIdentity, incoming, true)) continue;
            barrelIdentity.depositItemStack(incoming);
            if (incoming.getAmount() != 0) continue;
            return;
        }
        BlockMenu fallbackBlockMenu = null;
        int fallBackSlot = 0;
        for (BlockMenu blockMenu : this.getCellMenus()) {
            int i = 0;
            for (ItemStack itemStack : blockMenu.getContents()) {
                if (itemStack == null || itemStack.getType().isAir()) {
                    if (fallbackBlockMenu != null) continue;
                    fallbackBlockMenu = blockMenu;
                    fallBackSlot = i;
                    continue;
                }
                int itemStackAmount = itemStack.getAmount();
                int incomingStackAmount = incoming.getAmount();
                if (itemStackAmount < itemStack.getMaxStackSize() && StackUtils.itemsMatch(incoming, itemStack)) {
                    int maxCanAdd = itemStack.getMaxStackSize() - itemStackAmount;
                    int amountToAdd = Math.min(maxCanAdd, incomingStackAmount);
                    itemStack.setAmount(itemStackAmount + amountToAdd);
                    incoming.setAmount(incomingStackAmount - amountToAdd);
                    blockMenu.markDirty();
                    if (incomingStackAmount == 0) {
                        return;
                    }
                }
                ++i;
            }
        }
        if (fallbackBlockMenu != null) {
            fallbackBlockMenu.replaceExistingItem(fallBackSlot, incoming.clone());
            incoming.setAmount(0);
        }
    }

    @Override
    public long retrieveBlockCharge() {
        return 0L;
    }

    public long getRootPower() {
        return this.rootPower;
    }

    public void setRootPower(long power) {
        this.rootPower = power;
    }

    public void addRootPower(long power) {
        this.rootPower += power;
    }

    public void removeRootPower(long power) {
        int removed = 0;
        for (Location node : this.powerNodes) {
            SlimefunItem item = BlockStorage.check((Location)node);
            SlimefunItem slimefunItem = item;
            if (slimefunItem instanceof NetworkPowerNode) {
                NetworkPowerNode powerNode = (NetworkPowerNode)slimefunItem;
                int charge = powerNode.getCharge(node);
                if (charge <= 0) continue;
                int toRemove = (int)Math.min(power - (long)removed, (long)charge);
                powerNode.removeCharge(node, toRemove);
                this.rootPower -= power;
                removed += toRemove;
            }
            if ((long)removed < power) continue;
            return;
        }
    }

    public boolean isDisplayParticles() {
        return this.displayParticles;
    }

    public void setDisplayParticles(boolean displayParticles) {
        this.displayParticles = displayParticles;
    }
}

