/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.tools;

import de.jeff_media.morepersistentdatatypes.DataType;
import io.github.sefiraat.networks.slimefun.network.grid.NetworkGrid;
import io.github.sefiraat.networks.utils.Keys;
import io.github.sefiraat.networks.utils.Theme;
import io.github.sefiraat.networks.utils.datatypes.DataTypeMethods;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class NetworkRemote
extends SlimefunItem {
    private static final NamespacedKey KEY = Keys.newKey("location");
    private static final int[] RANGES = new int[]{150, 500, 0, -1};
    private final int range;

    public NetworkRemote(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int range) {
        super(itemGroup, item, recipeType, recipe);
        this.range = range;
        this.addItemHandler(new ItemHandler[]{new ItemUseHandler(){

            public void onRightClick(PlayerRightClickEvent e) {
                Player player = e.getPlayer();
                if (player.isSneaking()) {
                    Optional optional = e.getClickedBlock();
                    if (optional.isPresent()) {
                        Block block = (Block)optional.get();
                        SlimefunItem slimefunItem = BlockStorage.check((Block)block);
                        if (Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block, Interaction.INTERACT_BLOCK) && slimefunItem instanceof NetworkGrid) {
                            NetworkRemote.setGrid(e.getItem(), block, player);
                        } else {
                            player.sendMessage(Theme.ERROR + "Must be set to a Network Grid (not crafting grid).");
                        }
                    }
                } else {
                    NetworkRemote.tryOpenGrid(e.getItem(), player, NetworkRemote.this.range);
                }
                e.cancel();
            }
        }});
    }

    public static void setGrid(@Nonnull ItemStack itemStack, @Nonnull Block block, @Nonnull Player player) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        DataTypeMethods.setCustom((PersistentDataHolder)itemMeta, KEY, DataType.LOCATION, block.getLocation());
        itemStack.setItemMeta(itemMeta);
        player.sendMessage(Theme.SUCCESS + "Grid has been bound to the remote.");
    }

    public static void tryOpenGrid(@Nonnull ItemStack itemStack, @Nonnull Player player, int range) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        Location location = DataTypeMethods.getCustom((PersistentDataHolder)itemMeta, KEY, DataType.LOCATION);
        if (location != null) {
            if (!location.getWorld().isChunkLoaded(location.getBlockX() / 16, location.getBlockZ() / 16)) {
                player.sendMessage(Theme.ERROR + "The bound grid is not loaded.");
                return;
            }
            boolean sameDimension = location.getWorld().equals(player.getWorld());
            if (range == -1 || range == 0 && sameDimension || sameDimension && player.getLocation().distance(location) <= (double)range) {
                NetworkRemote.openGrid(location, player);
            } else {
                player.sendMessage(Theme.ERROR + "The bound grid is not within reach.");
            }
        } else {
            player.sendMessage(Theme.ERROR + "Remote is not bound to a grid.");
        }
    }

    public static void openGrid(@Nonnull Location location, @Nonnull Player player) {
        BlockMenu blockMenu = BlockStorage.getInventory((Location)location);
        SlimefunItem slimefunItem = BlockStorage.check((Location)location);
        if (slimefunItem instanceof NetworkGrid && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, location, Interaction.INTERACT_BLOCK)) {
            blockMenu.open(new Player[]{player});
        } else {
            player.sendMessage(Theme.ERROR + "The bound grid can no longer be found.");
        }
    }

    public int getRange() {
        return this.range;
    }

    public static int[] getRanges() {
        return RANGES;
    }
}

