/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.tools;

import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.slimefun.network.NetworkController;
import io.github.sefiraat.networks.slimefun.tools.CanCooldown;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NetworkProbe
extends SlimefunItem
implements CanCooldown {
    private static final MessageFormat MESSAGE_FORMAT = new MessageFormat("{0}{1}: {2}{3}", Locale.ROOT);

    public NetworkProbe(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{this::onUse});
    }

    protected void onUse(PlayerRightClickEvent e) {
        Optional optional = e.getClickedBlock();
        if (optional.isPresent()) {
            SlimefunItem slimefunItem;
            Block block = (Block)optional.get();
            Player player = e.getPlayer();
            if (this.canBeUsed(player, e.getItem()) && (slimefunItem = BlockStorage.check((Block)block)) instanceof NetworkController) {
                e.cancel();
                this.displayToPlayer(block, player);
                this.putOnCooldown(e.getItem());
            }
        }
    }

    private void displayToPlayer(@Nonnull Block block, @Nonnull Player player) {
        NetworkRoot root = NetworkController.getNetworks().get(block.getLocation());
        if (root != null) {
            int bridges = root.getBridges().size();
            int monitors = root.getMonitors().size();
            int importers = root.getImporters().size();
            int exporters = root.getExporters().size();
            int grids = root.getGrids().size();
            int cells = root.getCells().size();
            int wipers = root.getWipers().size();
            int grabbers = root.getGrabbers().size();
            int pushers = root.getPushers().size();
            int purgers = root.getPurgers().size();
            int crafters = root.getCrafters().size();
            int powerNodes = root.getPowerNodes().size();
            int powerDisplays = root.getPowerDisplays().size();
            int encoders = root.getEncoders().size();
            Map<ItemStack, Integer> allNetworkItems = root.getAllNetworkItems();
            int distinctItems = allNetworkItems.size();
            long totalItems = allNetworkItems.values().stream().mapToLong(integer -> integer.intValue()).sum();
            Object nodeCount = root.getNodeCount() >= root.getMaxNodes() ? Theme.ERROR + root.getNodeCount() + "+" : String.valueOf(root.getNodeCount());
            ChatColor c = Theme.CLICK_INFO.getColor();
            ChatColor p = Theme.PASSIVE.getColor();
            player.sendMessage("------------------------------");
            player.sendMessage("       Network Summary        ");
            player.sendMessage("------------------------------");
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Bridges", p, bridges}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Monitors", p, monitors}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Importers", p, importers}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Exporters", p, exporters}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Grids", p, grids}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Cells", p, cells}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Wipers", p, wipers}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Grabbers", p, grabbers}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Pushers", p, pushers}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Purgers", p, purgers}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Crafters", p, crafters}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Power Nodes", p, powerNodes}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Power Displays", p, powerDisplays}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Encoders", p, encoders}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Distinct Items", p, distinctItems}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Total Items", p, totalItems}, new StringBuffer(), (FieldPosition)null).toString());
            player.sendMessage("------------------------------");
            player.sendMessage(MESSAGE_FORMAT.format(new Object[]{c, "Total Nodes", p, (String)nodeCount + "/" + root.getMaxNodes()}, new StringBuffer(), (FieldPosition)null).toString());
            if (root.isOverburdened()) {
                player.sendMessage(Theme.ERROR + "Warning: " + Theme.PASSIVE + "Your network has reached or exceeded the maximum node limit. Nodes beyond the limit will not function, which nodes these are may not always be the same. Reduce your total nodes.");
            }
        }
    }

    @Override
    public int cooldownDuration() {
        return 10;
    }
}

