/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.network.stackcaches.QuantumCache;
import io.github.sefiraat.networks.slimefun.network.NetworkQuantumStorage;
import io.github.sefiraat.networks.utils.Keys;
import io.github.sefiraat.networks.utils.Theme;
import io.github.sefiraat.networks.utils.datatypes.DataTypeMethods;
import io.github.sefiraat.networks.utils.datatypes.PersistentQuantumStorageType;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class NetworkQuantumWorkbench
extends SlimefunItem {
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 14, 15, 16, 17, 18, 22, 24, 26, 27, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] RECIPE_SLOTS = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
    private static final int CRAFT_SLOT = 23;
    private static final int OUTPUT_SLOT = 25;
    private static final CustomItemStack CRAFT_BUTTON_STACK = new CustomItemStack(Material.CRAFTING_TABLE, Theme.CLICK_INFO + "Click to entangle", new String[0]);
    private static final Map<ItemStack[], ItemStack> RECIPES = new HashMap<ItemStack[], ItemStack>();
    public static final RecipeType TYPE = new RecipeType(Keys.newKey("quantum-workbench"), Theme.themedItemStack(Material.BRAIN_CORAL_BLOCK, Theme.MACHINE, "Quantum Workbench", "Crafted using the Quantum Workbench."), NetworkQuantumWorkbench::addRecipe, new String[0]);

    @ParametersAreNonnullByDefault
    public NetworkQuantumWorkbench(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{this.getBlockBreakHandler()});
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.drawBackground(BACKGROUND_SLOTS);
                this.addItem(23, (ItemStack)CRAFT_BUTTON_STACK, (p, slot, item, action) -> false);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return BlockStorage.check((Block)block).canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return new int[]{25};
                }
                return new int[0];
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                menu.addMenuClickHandler(23, (p, slot, item, action) -> {
                    NetworkQuantumWorkbench.this.craft(menu);
                    return false;
                });
            }
        };
    }

    public void craft(@Nonnull BlockMenu menu) {
        ItemStack itemInOutput = menu.getItemInSlot(25);
        if (itemInOutput != null) {
            return;
        }
        ItemStack[] inputs = new ItemStack[RECIPE_SLOTS.length];
        int i = 0;
        for (int recipeSlot : RECIPE_SLOTS) {
            ItemStack stack;
            inputs[i] = stack = menu.getItemInSlot(recipeSlot);
            ++i;
        }
        ItemStack crafted = null;
        for (Map.Entry<ItemStack[], ItemStack> entry : RECIPES.entrySet()) {
            if (!this.testRecipe(inputs, entry.getKey())) continue;
            crafted = entry.getValue().clone();
            break;
        }
        if (crafted != null) {
            ItemStack coreItem = inputs[4];
            SlimefunItem oldQuantum = SlimefunItem.getByItem((ItemStack)coreItem);
            if (oldQuantum instanceof NetworkQuantumStorage) {
                ItemMeta oldMeta = coreItem.getItemMeta();
                ItemMeta newMeta = crafted.getItemMeta();
                NetworkQuantumStorage newQuantum = (NetworkQuantumStorage)SlimefunItem.getByItem((ItemStack)crafted);
                QuantumCache oldCache = DataTypeMethods.getCustom((PersistentDataHolder)oldMeta, Keys.QUANTUM_STORAGE_INSTANCE, PersistentQuantumStorageType.TYPE);
                if (oldCache != null) {
                    QuantumCache newCache = new QuantumCache(oldCache.getItemStack().clone(), oldCache.getAmount(), newQuantum.getMaxAmount(), oldCache.isVoidExcess());
                    DataTypeMethods.setCustom((PersistentDataHolder)newMeta, Keys.QUANTUM_STORAGE_INSTANCE, PersistentQuantumStorageType.TYPE, newCache);
                    newCache.addMetaLore(newMeta);
                    crafted.setItemMeta(newMeta);
                }
            }
            menu.pushItem(crafted, new int[]{25});
            for (int recipeSlot : RECIPE_SLOTS) {
                if (menu.getItemInSlot(recipeSlot) == null) continue;
                menu.consumeItem(recipeSlot, 1, true);
            }
        }
    }

    private boolean testRecipe(ItemStack[] input, ItemStack[] recipe) {
        for (int test = 0; test < recipe.length; ++test) {
            if (SlimefunUtils.isItemSimilar((ItemStack)input[test], (ItemStack)recipe[test], (boolean)true, (boolean)false, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private BlockBreakHandler getBlockBreakHandler() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(BlockBreakEvent event, ItemStack itemStack, List<ItemStack> drops) {
                BlockMenu menu = BlockStorage.getInventory((Block)event.getBlock());
                menu.dropItems(menu.getLocation(), RECIPE_SLOTS);
                menu.dropItems(menu.getLocation(), new int[]{25});
            }
        };
    }

    public static void addRecipe(ItemStack[] input, ItemStack output) {
        RECIPES.put(input, output);
    }
}

