/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import com.bgsoftware.wildchests.api.WildChestsAPI;
import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.Networks;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.network.NetworkDirectional;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class NetworkVanillaPusher
extends NetworkDirectional {
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 15, 16, 17, 18, 20, 22, 23, 24, 26, 27, 28, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int INPUT_SLOT = 25;
    private static final int NORTH_SLOT = 11;
    private static final int SOUTH_SLOT = 29;
    private static final int EAST_SLOT = 21;
    private static final int WEST_SLOT = 19;
    private static final int UP_SLOT = 14;
    private static final int DOWN_SLOT = 32;

    public NetworkVanillaPusher(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.PUSHER);
        this.getSlotsToDrop().add(25);
    }

    @Override
    protected void onTick(@Nullable BlockMenu blockMenu, @Nonnull Block block) {
        super.onTick(blockMenu, block);
        if (blockMenu != null) {
            this.tryPushItem(blockMenu);
        }
    }

    private void tryPushItem(@Nonnull BlockMenu blockMenu) {
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
        if (definition == null || definition.getNode() == null) {
            return;
        }
        BlockFace direction = this.getCurrentDirection(blockMenu);
        Block block = blockMenu.getBlock();
        Block targetBlock = blockMenu.getBlock().getRelative(direction);
        UUID uuid = UUID.fromString(BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"uuid"));
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        if (!Slimefun.getProtectionManager().hasPermission(offlinePlayer, targetBlock, Interaction.INTERACT_BLOCK)) {
            return;
        }
        BlockState blockState = targetBlock.getState();
        BlockState blockState2 = blockState;
        if (!(blockState2 instanceof InventoryHolder)) {
            return;
        }
        InventoryHolder holder = (InventoryHolder)blockState2;
        Inventory inventory = holder.getInventory();
        ItemStack stack = blockMenu.getItemInSlot(25);
        if (stack == null || stack.getType() == Material.AIR) {
            return;
        }
        boolean wildChests = Networks.getSupportedPluginManager().isWildChests();
        boolean isChest = wildChests && WildChestsAPI.getChest((Location)targetBlock.getLocation()) != null;
        this.sendDebugMessage(block.getLocation(), "WildChests detected: " + wildChests);
        this.sendDebugMessage(block.getLocation(), "Block detected as chest: " + isChest);
        Inventory inventory2 = inventory;
        if (inventory2 instanceof FurnaceInventory) {
            FurnaceInventory furnace = (FurnaceInventory)inventory2;
            this.handleFurnace(stack, furnace);
        } else {
            inventory2 = inventory;
            if (inventory2 instanceof BrewerInventory) {
                BrewerInventory brewer = (BrewerInventory)inventory2;
                this.handleBrewingStand(stack, brewer);
            } else {
                if (wildChests && isChest) {
                    this.sendDebugMessage(block.getLocation(), "WildChest test failed, escaping");
                    return;
                }
                if (InvUtils.fits((Inventory)holder.getInventory(), (ItemStack)stack, (int[])new int[0])) {
                    this.sendDebugMessage(block.getLocation(), "WildChest test passed.");
                    holder.getInventory().addItem(new ItemStack[]{stack});
                    stack.setAmount(0);
                }
            }
        }
    }

    private void handleFurnace(@Nonnull ItemStack stack, @Nonnull FurnaceInventory furnace) {
        if (stack.getType().isFuel() && (furnace.getFuel() == null || furnace.getFuel().getType() == Material.AIR)) {
            furnace.setFuel(stack.clone());
            stack.setAmount(0);
        } else if (!(stack.getType().isFuel() || furnace.getSmelting() != null && furnace.getSmelting().getType() != Material.AIR)) {
            furnace.setSmelting(stack.clone());
            stack.setAmount(0);
        }
    }

    private void handleBrewingStand(@Nonnull ItemStack stack, @Nonnull BrewerInventory brewer) {
        if (stack.getType() == Material.BLAZE_POWDER) {
            if (brewer.getFuel() == null || brewer.getFuel().getType() == Material.AIR) {
                brewer.setFuel(stack.clone());
                stack.setAmount(0);
            }
        } else if (stack.getType() == Material.POTION) {
            for (int i = 0; i < 3; ++i) {
                ItemStack stackInSlot = brewer.getContents()[i];
                if (stackInSlot != null && stackInSlot.getType() != Material.AIR) continue;
                ItemStack[] contents = brewer.getContents();
                contents[i] = stack.clone();
                brewer.setContents(contents);
                stack.setAmount(0);
                return;
            }
        } else if (brewer.getIngredient() == null || brewer.getIngredient().getType() == Material.AIR) {
            brewer.setIngredient(stack.clone());
            stack.setAmount(0);
        }
    }

    @Override
    @Nonnull
    protected int[] getBackgroundSlots() {
        return BACKGROUND_SLOTS;
    }

    @Override
    public int getNorthSlot() {
        return 11;
    }

    @Override
    public int getSouthSlot() {
        return 29;
    }

    @Override
    public int getEastSlot() {
        return 21;
    }

    @Override
    public int getWestSlot() {
        return 19;
    }

    @Override
    public int getUpSlot() {
        return 14;
    }

    @Override
    public int getDownSlot() {
        return 32;
    }

    @Override
    public boolean runSync() {
        return true;
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{25};
    }

    @Override
    protected Particle.DustOptions getDustOptions() {
        return new Particle.DustOptions(Color.MAROON, 1.0f);
    }
}

