/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.network.NetworkDirectional;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class NetworkPowerOutlet
extends NetworkDirectional {
    private final int rate;

    public NetworkPowerOutlet(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int rate) {
        super(itemGroup, item, recipeType, recipe, NodeType.POWER_OUTLET);
        this.rate = rate;
    }

    @Override
    public void onTick(@Nullable BlockMenu menu, @Nonnull Block b) {
        int capacity;
        int space;
        EnergyNetComponent component;
        Block targetBlock;
        NodeDefinition definition;
        block9: {
            block8: {
                super.onTick(menu, b);
                if (menu == null) {
                    return;
                }
                definition = NetworkStorage.getAllNetworkObjects().get(b.getLocation());
                if (definition == null || definition.getNode() == null) {
                    return;
                }
                BlockFace blockFace = this.getCurrentDirection(menu);
                targetBlock = b.getRelative(blockFace);
                SlimefunItem slimefunItem = BlockStorage.check((Block)targetBlock);
                SlimefunItem slimefunItem2 = slimefunItem;
                if (!(slimefunItem2 instanceof EnergyNetComponent)) break block8;
                component = (EnergyNetComponent)slimefunItem2;
                if (!(slimefunItem instanceof NetworkObject)) break block9;
            }
            return;
        }
        String charge = BlockStorage.getLocationInfo((Location)targetBlock.getLocation(), (String)"energy-charge");
        int chargeInt = 0;
        if (charge != null) {
            chargeInt = Integer.parseInt(charge);
        }
        if ((space = (capacity = component.getCapacity()) - chargeInt) <= 0) {
            return;
        }
        int possibleGeneration = Math.min(this.rate, space);
        NetworkRoot root = definition.getNode().getRoot();
        long power = root.getRootPower();
        if (power <= 0L) {
            return;
        }
        int gen = power < (long)possibleGeneration ? (int)power : possibleGeneration;
        int chargeToRemove = (int)((double)gen * 1.2);
        component.addCharge(targetBlock.getLocation(), gen);
        root.removeRootPower(chargeToRemove);
    }
}

