/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.moreresearches;

import io.github.thebusybiscuit.slimefun4.api.events.SlimefunItemRegistryFinalizedEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import java.util.HashSet;
import java.util.stream.Collectors;
import me.justahuman.moreresearches.MoreResearches;
import me.justahuman.moreresearches.Utils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class RegistryListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onRegistryFinalized(SlimefunItemRegistryFinalizedEvent event) {
        FileConfiguration config = MoreResearches.getInstance().getConfig();
        ConfigurationSection researches = config.getConfigurationSection("researches");
        if (researches != null) {
            int researchCount = 0;
            HashSet uniqueItemIds = new HashSet();
            Utils.getLogger().info(Utils.translated("startup.load", new Object[0]));
            for (String researchId : researches.getKeys(false)) {
                ConfigurationSection researchConfig = researches.getConfigurationSection(researchId);
                if (researchConfig == null) {
                    Utils.getLogger().warning(Utils.translated("warnings.research.no-body", researchId));
                    continue;
                }
                Research research = Utils.createResearch(researchId, researchConfig);
                if (research == null) continue;
                ++researchCount;
                uniqueItemIds.addAll(research.getAffectedItems().stream().map(SlimefunItem::getId).collect(Collectors.toSet()));
            }
            Utils.getLogger().info(Utils.translated("startup.loaded", researchCount, uniqueItemIds.size()));
        }
    }
}

