/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.moreresearches;

import me.justahuman.moreresearches.MoreResearches;
import me.justahuman.moreresearches.ResearchEditor;
import me.justahuman.moreresearches.Utils;
import me.justahuman.moreresearches.acf.BaseCommand;
import me.justahuman.moreresearches.acf.CommandHelp;
import me.justahuman.moreresearches.acf.annotation.CommandAlias;
import me.justahuman.moreresearches.acf.annotation.CommandCompletion;
import me.justahuman.moreresearches.acf.annotation.CommandPermission;
import me.justahuman.moreresearches.acf.annotation.HelpCommand;
import me.justahuman.moreresearches.acf.annotation.Private;
import me.justahuman.moreresearches.acf.annotation.Subcommand;
import me.justahuman.moreresearches.acf.annotation.Syntax;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="more_researches|mr")
@CommandPermission(value="moreresearches.admin")
public class ResearchCommands
extends BaseCommand {
    @Syntax(value="")
    @Private
    @HelpCommand
    public void helpCommand(CommandSender sender, CommandHelp help) {
        help.showHelp();
    }

    @Subcommand(value="config set-lang")
    @CommandCompletion(value="@languages")
    public void setLang(CommandSender sender, String lang) {
        if (MoreResearches.getInstance().getResource("lang/" + lang + ".yml") == null) {
            sender.sendMessage(ChatColor.RED + Utils.translated("warnings.command.invalid-lang", lang));
            return;
        }
        MoreResearches.getInstance().getConfig().set("lang", (Object)lang);
        MoreResearches.getInstance().saveConfig();
        Utils.unchacheLangFile();
        sender.sendMessage(ChatColor.GREEN + Utils.translated("command.set-lang", lang));
    }

    @Subcommand(value="config reload")
    public void reload(CommandSender sender) {
        MoreResearches.getInstance().reloadConfig();
        Utils.unchacheLangFile();
        sender.sendMessage(ChatColor.GREEN + Utils.translated("command.reload", new Object[0]));
        Utils.loadResearches();
    }

    @Subcommand(value="editor")
    public void editor(Player player) {
        ResearchEditor.openMainMenu(player);
    }

    @Subcommand(value="editor confirm")
    public void editorConfirm(Player player) {
        ResearchEditor.handleCallback(player, "confirm");
    }

    @Subcommand(value="editor cancel")
    public void editorCancel(Player player) {
        ResearchEditor.handleCallback(player, "cancel");
    }
}

