/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.moreresearches;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import me.justahuman.moreresearches.MoreResearches;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Utils {
    private static final Map<SlimefunItem, Research> ORIGINAL_RESEARCHES = new HashMap<SlimefunItem, Research>();
    private static final Field RESEARCH_NAME_FIELD;
    private static YamlConfiguration langFile;

    public static void loadResearches() {
        FileConfiguration config = MoreResearches.getInstance().getConfig();
        ConfigurationSection researches = config.getConfigurationSection("researches");
        HashMap<String, Research> customResearches = new HashMap<String, Research>();
        for (Research research : new ArrayList(Slimefun.getRegistry().getResearches())) {
            if (!Utils.isCustomResearch(research)) continue;
            for (SlimefunItem slimefunItem : new ArrayList(research.getAffectedItems())) {
                slimefunItem.setResearch(ORIGINAL_RESEARCHES.get(slimefunItem));
            }
            String researchId = research.getKey().getKey();
            if (researches == null || !researches.contains(researchId)) {
                Slimefun.getRegistry().getResearches().remove(research);
            }
            customResearches.put(researchId, research);
        }
        if (researches != null) {
            for (String researchId : researches.getKeys(false)) {
                Research research = (Research)customResearches.get(researchId);
                ConfigurationSection researchConfig = researches.getConfigurationSection(researchId);
                if (research == null && researchConfig != null) {
                    Utils.createResearch(researchId, researchConfig);
                    continue;
                }
                if (research == null || researchConfig == null) continue;
                Utils.updateResearch(research, researchId, researchConfig);
            }
        }
    }

    public static Research createResearch(String researchId, ConfigurationSection researchConfig) {
        MoreResearches plugin = MoreResearches.getInstance();
        int legacyId = researchConfig.getInt("legacy-id", -113132);
        if (legacyId == -113132) {
            Utils.getLogger().warning("Invalid research, you need to set a legacy-id, negative numbers are recommended: " + researchId);
            return null;
        }
        String displayName = researchConfig.getString("display-name", "Error: No Display Name Provided");
        int expCost = researchConfig.getInt("exp-cost", 0);
        List itemIds = researchConfig.getStringList("slimefun-items");
        if (itemIds.isEmpty()) {
            Utils.getLogger().warning("Invalid research, no items: " + researchId);
            return null;
        }
        SlimefunItem[] items = (SlimefunItem[])itemIds.stream().map(SlimefunItem::getById).filter(Objects::nonNull).toArray(SlimefunItem[]::new);
        if (items.length == 0) {
            Utils.getLogger().warning("Invalid research, no valid items: " + researchId);
            return null;
        }
        for (SlimefunItem item : items) {
            if (ORIGINAL_RESEARCHES.containsKey(item) || Utils.isCustomResearch(item.getResearch())) continue;
            ORIGINAL_RESEARCHES.put(item, item.getResearch());
        }
        Research research = new Research(new NamespacedKey((Plugin)plugin, researchId), legacyId, displayName, expCost);
        research.addItems(items);
        research.register();
        return research;
    }

    public static void updateResearch(Research research, String researchId, ConfigurationSection researchConfig) {
        List itemIds = researchConfig.getStringList("slimefun-items");
        if (itemIds.isEmpty()) {
            Utils.getLogger().warning("Invalid research, no items: " + researchId);
            return;
        }
        SlimefunItem[] items = (SlimefunItem[])itemIds.stream().map(SlimefunItem::getById).filter(Objects::nonNull).toArray(SlimefunItem[]::new);
        if (items.length == 0) {
            Utils.getLogger().warning("Invalid research, no valid items: " + researchId);
            return;
        }
        for (SlimefunItem item : items) {
            if (ORIGINAL_RESEARCHES.containsKey(item) || Utils.isCustomResearch(item.getResearch())) continue;
            ORIGINAL_RESEARCHES.put(item, item.getResearch());
        }
        try {
            RESEARCH_NAME_FIELD.set(research, researchConfig.getString("display-name", "Error: No Display Name Provided"));
        }
        catch (Exception e) {
            Utils.getLogger().severe("Ran into a problem updating " + researchId + "'s name!");
            Utils.getLogger().throwing("Utils", "updateResearch", e);
            return;
        }
        research.setCost(researchConfig.getInt("exp-cost", 0));
        research.addItems(items);
    }

    public static List<String> compressIds(List<String> words) {
        int totalWords = words.size();
        int numGroups = (int)Math.ceil(Math.sqrt(totalWords));
        int targetGroupSize = (int)Math.ceil((double)totalWords / (double)numGroups);
        ArrayList<String> compressedWords = new ArrayList<String>();
        StringBuilder currentGroup = new StringBuilder("&e");
        for (int i = 0; i < totalWords; ++i) {
            currentGroup.append(words.get(i)).append(", ");
            if ((i + 1) % targetGroupSize != 0 && i != totalWords - 1) continue;
            compressedWords.add(currentGroup.toString().trim());
            currentGroup = new StringBuilder("&e");
        }
        return compressedWords;
    }

    public static void unchacheLangFile() {
        langFile = null;
    }

    public static void cacheLangFile() {
        if (langFile == null) {
            FileConfiguration config;
            String language;
            MoreResearches researches = MoreResearches.getInstance();
            InputStream lang = researches.getResource("lang/" + (language = (config = researches.getConfig()).getString("lang", "en_us")) + ".yml");
            if (lang == null) {
                lang = researches.getResource("lang/en_us.yml");
            }
            if (lang == null) {
                return;
            }
            langFile = YamlConfiguration.loadConfiguration((Reader)new BufferedReader(new InputStreamReader(lang, StandardCharsets.UTF_8)));
        }
    }

    public static void send(Player player, String key, Object ... args) {
        player.sendMessage(Utils.translated(key, args));
    }

    public static String translated(String key, Object ... args) {
        Utils.cacheLangFile();
        if (langFile == null) {
            return "Error: No Language File Found!";
        }
        return ChatColors.color((String)langFile.getString(key, "Error: No Translation for \"" + key + "\" Found!").formatted(args));
    }

    public static List<String> translatedList(String key, Object ... args) {
        Utils.cacheLangFile();
        if (langFile == null) {
            return List.of("Error: No Language File Found!");
        }
        return new ArrayList<String>(langFile.getStringList(key).stream().map(s -> ChatColors.color((String)s.formatted(args))).toList());
    }

    public static ItemStack translatedStack(Material base, String key, Object ... args) {
        String name = Utils.translated(key + ".name", args);
        List<String> lore = Utils.translatedList(key + ".lore", args);
        return new CustomItemStack(base, name, lore);
    }

    public static ItemStack translatedStack(ItemStack base, String key, Object ... args) {
        String name = Utils.translated(key + ".name", args);
        List<String> lore = Utils.translatedList(key + ".lore", args);
        return new CustomItemStack(base, name, lore.toArray(new String[0]));
    }

    public static ItemStack updateStack(ItemStack stack, String key, Object ... args) {
        String name = Utils.translated(key + ".name", args);
        List<String> lore = Utils.translatedList(key + ".lore", args);
        ItemMeta meta = stack.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(lore);
            stack.setItemMeta(meta);
        }
        return stack;
    }

    public static boolean isCustomResearch(Research research) {
        return research != null && research.getKey().getNamespace().equalsIgnoreCase("moreresearches");
    }

    public static Logger getLogger() {
        return MoreResearches.getInstance().getLogger();
    }

    static {
        try {
            RESEARCH_NAME_FIELD = Research.class.getDeclaredField("name");
            RESEARCH_NAME_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        langFile = null;
    }
}

