/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.moreresearches;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import me.justahuman.moreresearches.MoreResearches;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class Utils {
    private static final Map<SlimefunItem, Research> ORIGINAL_RESEARCHES = new HashMap<SlimefunItem, Research>();
    private static final Field RESEARCH_NAME_FIELD;

    public static void loadResearches() {
        FileConfiguration config = MoreResearches.getInstance().getConfig();
        ConfigurationSection researches = config.getConfigurationSection("researches");
        HashMap<String, Research> customResearches = new HashMap<String, Research>();
        for (Research research : new ArrayList(Slimefun.getRegistry().getResearches())) {
            if (!Utils.isCustomResearch(research)) continue;
            for (SlimefunItem slimefunItem : new ArrayList(research.getAffectedItems())) {
                slimefunItem.setResearch(ORIGINAL_RESEARCHES.get(slimefunItem));
            }
            String researchId = research.getKey().getKey();
            if (researches == null || !researches.contains(researchId)) {
                Slimefun.getRegistry().getResearches().remove(research);
            }
            customResearches.put(researchId, research);
        }
        if (researches != null) {
            for (String researchId : researches.getKeys(false)) {
                Research research = (Research)customResearches.get(researchId);
                ConfigurationSection researchConfig = researches.getConfigurationSection(researchId);
                if (research == null && researchConfig != null) {
                    Utils.createResearch(researchId, researchConfig);
                    continue;
                }
                if (research == null || researchConfig == null) continue;
                Utils.updateResearch(research, researchId, researchConfig);
            }
        }
    }

    public static Research createResearch(String researchId, ConfigurationSection researchConfig) {
        MoreResearches plugin = MoreResearches.getInstance();
        int legacyId = researchConfig.getInt("legacy-id", -113132);
        if (legacyId == -113132) {
            Utils.getLogger().warning("Invalid research, you need to set a legacy-id, negative numbers are recommended: " + researchId);
            return null;
        }
        String displayName = researchConfig.getString("display-name", "Error: No Display Name Provided");
        int expCost = researchConfig.getInt("exp-cost", 0);
        List itemIds = researchConfig.getStringList("slimefun-items");
        if (itemIds.isEmpty()) {
            Utils.getLogger().warning("Invalid research, no items: " + researchId);
            return null;
        }
        SlimefunItem[] items = (SlimefunItem[])itemIds.stream().map(SlimefunItem::getById).filter(Objects::nonNull).toArray(SlimefunItem[]::new);
        if (items.length == 0) {
            Utils.getLogger().warning("Invalid research, no valid items: " + researchId);
            return null;
        }
        for (SlimefunItem item : items) {
            if (ORIGINAL_RESEARCHES.containsKey(item) || Utils.isCustomResearch(item.getResearch())) continue;
            ORIGINAL_RESEARCHES.put(item, item.getResearch());
        }
        Research research = new Research(new NamespacedKey((Plugin)plugin, researchId), legacyId, displayName, expCost);
        research.addItems(items);
        research.register();
        return research;
    }

    public static void updateResearch(Research research, String researchId, ConfigurationSection researchConfig) {
        List itemIds = researchConfig.getStringList("slimefun-items");
        if (itemIds.isEmpty()) {
            Utils.getLogger().warning("Invalid research, no items: " + researchId);
            return;
        }
        SlimefunItem[] items = (SlimefunItem[])itemIds.stream().map(SlimefunItem::getById).filter(Objects::nonNull).toArray(SlimefunItem[]::new);
        if (items.length == 0) {
            Utils.getLogger().warning("Invalid research, no valid items: " + researchId);
            return;
        }
        for (SlimefunItem item : items) {
            if (ORIGINAL_RESEARCHES.containsKey(item) || Utils.isCustomResearch(item.getResearch())) continue;
            ORIGINAL_RESEARCHES.put(item, item.getResearch());
        }
        try {
            RESEARCH_NAME_FIELD.set(research, researchConfig.getString("display-name", "Error: No Display Name Provided"));
        }
        catch (Exception e) {
            Utils.getLogger().severe("Ran into a problem updating " + researchId + "'s name!");
            Utils.getLogger().throwing("Utils", "updateResearch", e);
            return;
        }
        research.setCost(researchConfig.getInt("exp-cost", 0));
        research.addItems(items);
    }

    public static List<String> compressIds(List<String> words) {
        int totalWords = words.size();
        int numGroups = (int)Math.ceil(Math.sqrt(totalWords));
        int targetGroupSize = (int)Math.ceil((double)totalWords / (double)numGroups);
        ArrayList<String> compressedWords = new ArrayList<String>();
        StringBuilder currentGroup = new StringBuilder("&e");
        for (int i = 0; i < totalWords; ++i) {
            currentGroup.append(words.get(i)).append(", ");
            if ((i + 1) % targetGroupSize != 0 && i != totalWords - 1) continue;
            compressedWords.add(currentGroup.toString().trim());
            currentGroup = new StringBuilder("&e");
        }
        return compressedWords;
    }

    public static boolean isCustomResearch(Research research) {
        return research != null && research.getKey().getNamespace().equalsIgnoreCase("moreresearches");
    }

    public static Logger getLogger() {
        return MoreResearches.getInstance().getLogger();
    }

    static {
        try {
            RESEARCH_NAME_FIELD = Research.class.getDeclaredField("name");
            RESEARCH_NAME_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

