/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AbstractHumanoidAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Zombie;

public class ZombieAdapter<T extends Zombie>
extends AbstractHumanoidAdapter<T> {
    public ZombieAdapter(Class<T> entityClass) {
        super(entityClass);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Baby: " + String.valueOf(ChatColor.WHITE) + json.get("baby").getAsBoolean());
        return lore;
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull T entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("age", (Number)entity.getAge());
        json.addProperty("baby", Boolean.valueOf(!entity.isAdult()));
        if (entity.isConverting()) {
            json.addProperty("conversionTime", (Number)entity.getConversionTime());
        }
        return json;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(T entity, JsonObject json) {
        super.apply(entity, json);
        entity.setAge(json.get("age").getAsInt());
        if (json.has("conversionTime")) {
            entity.setConversionTime(json.get("conversionTime").getAsInt());
        }
    }
}

