/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.MobAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Slime;

public class SlimeAdapter<T extends Slime>
implements MobAdapter<T> {
    private final Class<T> entityClass;

    public SlimeAdapter(@Nonnull Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = MobAdapter.super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Size: " + String.valueOf(ChatColor.WHITE) + json.get("size").getAsInt());
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(T entity, JsonObject json) {
        MobAdapter.super.apply(entity, json);
        entity.setSize(json.get("size").getAsInt());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull T entity) {
        JsonObject json = MobAdapter.super.saveData(entity);
        json.addProperty("size", (Number)entity.getSize());
        return json;
    }

    @Override
    @Nonnull
    public Class<T> getEntityClass() {
        return this.entityClass;
    }
}

