/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AnimalsAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Panda;

public class PandaAdapter
extends AnimalsAdapter<Panda> {
    public PandaAdapter() {
        super(Panda.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Main Gene: " + String.valueOf(ChatColor.WHITE) + ChatUtils.humanize((String)json.get("mainGene").getAsString()));
        lore.add(String.valueOf(ChatColor.GRAY) + "Hidden Gene: " + String.valueOf(ChatColor.WHITE) + ChatUtils.humanize((String)json.get("hiddenGene").getAsString()));
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Panda entity, JsonObject json) {
        super.apply(entity, json);
        entity.setMainGene(Panda.Gene.valueOf((String)json.get("mainGene").getAsString()));
        entity.setHiddenGene(Panda.Gene.valueOf((String)json.get("hiddenGene").getAsString()));
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Panda entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("mainGene", entity.getMainGene().name());
        json.addProperty("hiddenGene", entity.getHiddenGene().name());
        return json;
    }
}

