/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.utils.compatibility;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.MobCapturer;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Registry;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;

public final class AttributeX {
    private static final List<Object> allAttributes = new ArrayList<Object>();

    @Nonnull
    public static JsonObject serializeAttributesFromEntity(@Nonnull LivingEntity entity) {
        JsonObject attributes = new JsonObject();
        for (Object attribute : allAttributes) {
            AttributeInstance instance = (AttributeInstance)ReflectionUtils.invoke(entity, "getAttribute", attribute);
            if (instance == null) continue;
            JsonObject attributeObj = new JsonObject();
            attributeObj.addProperty("base", (Number)instance.getBaseValue());
            JsonArray modifiers = new JsonArray();
            for (AttributeModifier modifier : instance.getModifiers()) {
                JsonObject mod = new JsonObject();
                Map serializedMod = modifier.serialize();
                for (Map.Entry entry : serializedMod.entrySet()) {
                    mod.addProperty((String)entry.getKey(), entry.getValue().toString());
                }
                modifiers.add((JsonElement)mod);
            }
            attributeObj.add("modifiers", (JsonElement)modifiers);
            attributes.add(attribute.toString(), (JsonElement)attributeObj);
        }
        return attributes;
    }

    private AttributeX() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        try {
            Object registry = ReflectionUtils.valueOf(Registry.class, "ATTRIBUTE");
            Object registryIterator = ReflectionUtils.invoke(registry, "iterator", new Object[0]);
            while (((Boolean)ReflectionUtils.invoke(registryIterator, "hasNext", new Object[0])).booleanValue()) {
                allAttributes.add(ReflectionUtils.invoke(registryIterator, "next", new Object[0]));
            }
        }
        catch (Exception ex) {
            MobCapturer.getInstance().getLogger().log(Level.SEVERE, "Failed to load attributes", ex);
        }
    }
}

