/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.utils;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import java.lang.reflect.Type;
import java.util.Map;

public final class JsonUtils {
    private static final Gson GSON = new Gson();

    @Nonnull
    public static Map<String, Object> toMap(@Nonnull JsonObject obj) {
        Preconditions.checkArgument((obj != null ? 1 : 0) != 0, (Object)"JsonObject cannot be null");
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)GSON.fromJson((JsonElement)obj, type);
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

