/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.InventoryAdapter;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AbstractTameableAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.guizhanss.guizhanlib.minecraft.utils.MinecraftVersionUtil;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class WolfAdapter
extends AbstractTameableAdapter<Wolf>
implements InventoryAdapter<Wolf> {
    private final Registry wolfVariantRegistry = MinecraftVersionUtil.isAtLeast(20, 5) ? RegistryAccess.registryAccess().getRegistry(RegistryKey.WOLF_VARIANT) : null;

    public WolfAdapter() {
        super(Wolf.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        if (!json.get("ownerUUID").isJsonNull()) {
            lore.add(String.valueOf(ChatColor.GRAY) + "Collar Color: " + String.valueOf(ChatColor.WHITE) + ChatUtils.humanize((String)json.get("collarColor").getAsString()));
            lore.add(String.valueOf(ChatColor.GRAY) + "Sitting: " + String.valueOf(ChatColor.WHITE) + json.get("sitting").getAsBoolean());
        } else {
            lore.add(String.valueOf(ChatColor.GRAY) + "Angry: " + String.valueOf(ChatColor.WHITE) + json.get("angry").getAsBoolean());
        }
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Wolf entity, JsonObject json) {
        super.apply(entity, json);
        entity.setAngry(json.get("angry").getAsBoolean());
        entity.setSitting(json.get("sitting").getAsBoolean());
        entity.setCollarColor(DyeColor.valueOf((String)json.get("collarColor").getAsString()));
        if (MinecraftVersionUtil.isAtLeast(20, 5) && json.has("variant")) {
            entity.setVariant((Wolf.Variant)this.wolfVariantRegistry.get(NamespacedKey.fromString((String)json.get("variant").getAsString())));
        }
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Wolf entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("angry", Boolean.valueOf(entity.isAngry()));
        json.addProperty("sitting", Boolean.valueOf(entity.isSitting()));
        json.addProperty("collarColor", entity.getCollarColor().name());
        if (MinecraftVersionUtil.isAtLeast(20, 5)) {
            json.addProperty("variant", entity.getVariant().getKey().toString());
        }
        return json;
    }

    @Override
    public void applyInventory(Wolf entity, Map<String, ItemStack> inventory) {
        if (MinecraftVersionUtil.isAtLeast(20, 5)) {
            ItemStack wolfArmor = inventory.get("body");
            entity.getEquipment().setItem(EquipmentSlot.BODY, wolfArmor);
        }
    }

    @Override
    @Nonnull
    public Map<String, ItemStack> saveInventory(@Nonnull Wolf entity) {
        HashMap<String, ItemStack> inventory = new HashMap<String, ItemStack>();
        if (MinecraftVersionUtil.isAtLeast(20, 5)) {
            ItemStack wolfArmor = entity.getEquipment().getItem(EquipmentSlot.BODY);
            inventory.put("body", wolfArmor);
        }
        return inventory;
    }
}

