/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AbstractHorseAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.inventory.ItemStack;

public class ChestedHorseAdapter<T extends ChestedHorse>
extends AbstractHorseAdapter<T> {
    public ChestedHorseAdapter(@Nonnull Class<T> entityClass) {
        super(entityClass);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Chest: " + String.valueOf(ChatColor.WHITE) + json.get("chest").getAsBoolean());
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(T entity, JsonObject json) {
        super.apply(entity, json);
        entity.setCarryingChest(json.get("chest").getAsBoolean());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull T entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("chest", Boolean.valueOf(entity.isCarryingChest()));
        return json;
    }

    @Override
    @Nonnull
    public Map<String, ItemStack> saveInventory(@Nonnull T entity) {
        HashMap<String, ItemStack> inv = new HashMap<String, ItemStack>();
        for (int slot = 0; slot < entity.getInventory().getSize(); ++slot) {
            inv.put(String.valueOf(slot), entity.getInventory().getItem(slot));
        }
        return inv;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void applyInventory(T entity, Map<String, ItemStack> inventory) {
        for (Map.Entry<String, ItemStack> entry : inventory.entrySet()) {
            entity.getInventory().setItem(Integer.parseInt(entry.getKey()), entry.getValue());
        }
    }
}

