/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AnimalsAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Axolotl;

public class AxolotlAdapter
extends AnimalsAdapter<Axolotl> {
    public AxolotlAdapter() {
        super(Axolotl.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Variant: " + String.valueOf(ChatColor.WHITE) + ChatUtils.humanize((String)json.get("variant").getAsString()));
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Axolotl entity, JsonObject json) {
        super.apply(entity, json);
        entity.setVariant(Axolotl.Variant.valueOf((String)json.get("variant").getAsString()));
        entity.setPlayingDead(json.get("isPlayingDead").getAsBoolean());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Axolotl entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("variant", entity.getVariant().name());
        json.addProperty("isPlayingDead", Boolean.valueOf(entity.isPlayingDead()));
        return json;
    }
}

