/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.InventoryAdapter;
import io.github.thebusybiscuit.mobcapturer.adapters.MobAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Allay;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class AllayAdapter
implements MobAdapter<Allay>,
InventoryAdapter<Allay> {
    @Override
    @ParametersAreNonnullByDefault
    public void apply(Allay entity, JsonObject json) {
        MobAdapter.super.apply(entity, json);
        if (this.hasAllayMethods() && json.has("duplicationCooldown")) {
            entity.setDuplicationCooldown(json.get("duplicationCooldown").getAsLong());
        }
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Allay entity) {
        JsonObject json = MobAdapter.super.saveData(entity);
        if (this.hasAllayMethods()) {
            json.addProperty("duplicationCooldown", (Number)entity.getDuplicationCooldown());
        }
        return json;
    }

    private boolean hasAllayMethods() {
        try {
            Allay.class.getMethod("getDuplicationCooldown", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    @Override
    @Nonnull
    public Map<String, ItemStack> saveInventory(@Nonnull Allay entity) {
        HashMap<String, ItemStack> inv = new HashMap<String, ItemStack>();
        EntityEquipment equipment = entity.getEquipment();
        if (equipment != null) {
            inv.put("mainHand", equipment.getItemInMainHand());
        }
        return inv;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void applyInventory(Allay entity, Map<String, ItemStack> inventory) {
        EntityEquipment equipment = entity.getEquipment();
        if (equipment != null) {
            equipment.setItemInMainHand(inventory.get("mainHand"));
        }
    }

    @Override
    @Nonnull
    public Class<Allay> getEntityClass() {
        return Allay.class;
    }
}

