/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.MobAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.entity.Shulker;

public class ShulkerAdapter
implements MobAdapter<Shulker> {
    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = MobAdapter.super.getLore(json);
        JsonElement color = json.get("color");
        if (!color.isJsonNull()) {
            lore.add(String.valueOf(ChatColor.GRAY) + "Color: " + String.valueOf(ChatColor.WHITE) + ChatUtils.humanize((String)color.getAsString()));
        }
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Shulker entity, JsonObject json) {
        MobAdapter.super.apply(entity, json);
        JsonElement color = json.get("color");
        if (!color.isJsonNull()) {
            entity.setColor(DyeColor.valueOf((String)color.getAsString()));
        }
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Shulker entity) {
        JsonObject json = MobAdapter.super.saveData(entity);
        DyeColor color = entity.getColor();
        json.addProperty("color", color == null ? null : color.name());
        return json;
    }

    @Override
    @Nonnull
    public Class<Shulker> getEntityClass() {
        return Shulker.class;
    }
}

