/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.MobAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Enderman;

public class EndermanAdapter
implements MobAdapter<Enderman> {
    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = MobAdapter.super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Carrying block: " + String.valueOf(ChatColor.WHITE) + json.has("carriedBlock"));
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Enderman entity, JsonObject json) {
        MobAdapter.super.apply(entity, json);
        if (json.has("carriedBlock")) {
            BlockData blockData = Bukkit.getServer().createBlockData(json.get("carriedBlock").getAsString());
            entity.setCarriedBlock(blockData);
        }
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Enderman entity) {
        JsonObject json = MobAdapter.super.saveData(entity);
        BlockData blockData = entity.getCarriedBlock();
        if (blockData != null) {
            json.addProperty("carriedBlock", blockData.getAsString());
        }
        return json;
    }

    @Override
    @Nonnull
    public Class<Enderman> getEntityClass() {
        return Enderman.class;
    }
}

