/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.InventoryAdapter;
import io.github.thebusybiscuit.mobcapturer.adapters.MobAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Monster;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

class AbstractHumanoidAdapter<T extends Monster>
implements MobAdapter<T>,
InventoryAdapter<T> {
    private final Class<T> entityClass;

    public AbstractHumanoidAdapter(@Nonnull Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(T entity, JsonObject json) {
        EntityEquipment equipment;
        MobAdapter.super.apply(entity, json);
        JsonElement element = json.get("canPickupItems");
        if (!element.isJsonNull()) {
            entity.setCanPickupItems(element.getAsBoolean());
        }
        if ((equipment = entity.getEquipment()) != null) {
            equipment.setItemInMainHandDropChance(json.get("mainHandDropChance").getAsFloat());
            equipment.setItemInOffHandDropChance(json.get("offHandDropChance").getAsFloat());
            equipment.setHelmetDropChance(json.get("helmetDropChance").getAsFloat());
            equipment.setChestplateDropChance(json.get("chestplateDropChance").getAsFloat());
            equipment.setLeggingsDropChance(json.get("leggingsDropChance").getAsFloat());
            equipment.setBootsDropChance(json.get("bootsDropChance").getAsFloat());
        }
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull T entity) {
        JsonObject json = MobAdapter.super.saveData(entity);
        json.addProperty("canPickupItems", Boolean.valueOf(entity.getCanPickupItems()));
        EntityEquipment equipment = entity.getEquipment();
        if (equipment != null) {
            json.addProperty("mainHandDropChance", (Number)Float.valueOf(equipment.getItemInMainHandDropChance()));
            json.addProperty("offHandDropChance", (Number)Float.valueOf(equipment.getItemInOffHandDropChance()));
            json.addProperty("helmetDropChance", (Number)Float.valueOf(equipment.getHelmetDropChance()));
            json.addProperty("chestplateDropChance", (Number)Float.valueOf(equipment.getChestplateDropChance()));
            json.addProperty("leggingsDropChance", (Number)Float.valueOf(equipment.getLeggingsDropChance()));
            json.addProperty("bootsDropChance", (Number)Float.valueOf(equipment.getBootsDropChance()));
        }
        return json;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void applyInventory(T entity, Map<String, ItemStack> inventory) {
        EntityEquipment equipment = entity.getEquipment();
        if (equipment != null) {
            equipment.setItemInMainHand(inventory.get("mainHand"));
            equipment.setItemInOffHand(inventory.get("offHand"));
            equipment.setHelmet(inventory.get("helmet"));
            equipment.setChestplate(inventory.get("chestplate"));
            equipment.setLeggings(inventory.get("leggings"));
            equipment.setBoots(inventory.get("boots"));
        }
    }

    @Override
    @Nonnull
    public Map<String, ItemStack> saveInventory(@Nonnull T entity) {
        HashMap<String, ItemStack> inv = new HashMap<String, ItemStack>();
        EntityEquipment equipment = entity.getEquipment();
        if (equipment != null) {
            inv.put("mainHand", equipment.getItemInMainHand());
            inv.put("offHand", equipment.getItemInOffHand());
            inv.put("helmet", equipment.getHelmet());
            inv.put("chestplate", equipment.getChestplate());
            inv.put("leggings", equipment.getLeggings());
            inv.put("boots", equipment.getBoots());
        }
        return inv;
    }

    @Override
    @Nonnull
    public Class<T> getEntityClass() {
        return this.entityClass;
    }
}

