/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.AbstractHorseAdapter;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.general.String.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

public class HorseAdapter
extends AbstractHorseAdapter<Horse> {
    public HorseAdapter() {
        super(Horse.class);
    }

    @Override
    public List<String> getLore(JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Style: " + ChatColor.WHITE + StringUtils.format((String)json.get("style").getAsString()));
        lore.add(ChatColor.GRAY + "Color: " + ChatColor.WHITE + StringUtils.format((String)json.get("color").getAsString()));
        return lore;
    }

    @Override
    public void apply(Horse entity, JsonObject json) {
        super.apply(entity, json);
        entity.setStyle(Horse.Style.valueOf((String)json.get("style").getAsString()));
        entity.setColor(Horse.Color.valueOf((String)json.get("color").getAsString()));
    }

    @Override
    public JsonObject saveData(Horse entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("style", entity.getStyle().name());
        json.addProperty("color", entity.getColor().name());
        return json;
    }

    @Override
    public void applyInventory(Horse entity, Map<String, ItemStack> inventory) {
        super.applyInventory(entity, inventory);
        inventory.put("armor", entity.getInventory().getArmor());
    }

    @Override
    public Map<String, ItemStack> saveInventory(Horse entity) {
        Map<String, ItemStack> inventory = super.saveInventory(entity);
        inventory.put("armor", entity.getInventory().getArmor());
        return inventory;
    }
}

