/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.AbstractHumanoidAdapter;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Zombie;

public class ZombieAdapter<T extends Zombie>
extends AbstractHumanoidAdapter<T> {
    public ZombieAdapter(Class<T> entityClass) {
        super(entityClass);
    }

    @Override
    public List<String> getLore(JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Baby: " + ChatColor.RESET + json.get("baby").getAsBoolean());
        return lore;
    }

    @Override
    public JsonObject saveData(T entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("baby", Boolean.valueOf(entity.isBaby()));
        if (entity.isConverting()) {
            json.addProperty("conversionTime", (Number)entity.getConversionTime());
        }
        return json;
    }

    @Override
    public void apply(T entity, JsonObject json) {
        super.apply(entity, json);
        entity.setBaby(json.get("baby").getAsBoolean());
        if (json.has("conversionTime")) {
            entity.setConversionTime(json.get("conversionTime").getAsInt());
        }
    }
}

