/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.TameableAdapter;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.general.String.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.entity.Cat;

public class CatAdapter
extends TameableAdapter<Cat> {
    public CatAdapter() {
        super(Cat.class);
    }

    @Override
    public List<String> getLore(JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Variant: " + ChatColor.RESET + StringUtils.format((String)json.get("catType").getAsString()));
        if (!json.get("ownerUUID").isJsonNull()) {
            lore.add(ChatColor.GRAY + "Collar Color: " + ChatColor.RESET + StringUtils.format((String)json.get("collarColor").getAsString()));
            lore.add(ChatColor.GRAY + "Sitting: " + ChatColor.RESET + json.get("sitting").getAsBoolean());
        }
        return lore;
    }

    @Override
    public void apply(Cat entity, JsonObject json) {
        super.apply(entity, json);
        entity.setCatType(Cat.Type.valueOf((String)json.get("catType").getAsString()));
        entity.setSitting(json.get("sitting").getAsBoolean());
        entity.setCollarColor(DyeColor.valueOf((String)json.get("collarColor").getAsString()));
    }

    @Override
    public JsonObject save(Cat entity) {
        JsonObject json = super.save(entity);
        json.addProperty("catType", entity.getCatType().name());
        json.addProperty("sitting", Boolean.valueOf(entity.isSitting()));
        json.addProperty("collarColor", entity.getCollarColor().name());
        return json;
    }
}

