/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AbstractHorseAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Camel;

public class CamelAdapter<T extends Camel>
extends AbstractHorseAdapter<T> {
    public CamelAdapter(@Nonnull Class<T> entityClass) {
        super(entityClass);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Dashing: " + String.valueOf(ChatColor.WHITE) + json.get("dashing").getAsBoolean());
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(T entity, JsonObject json) {
        super.apply(entity, json);
        entity.setDashing(json.get("dashing").getAsBoolean());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull T entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("dashing", Boolean.valueOf(entity.isDashing()));
        return json;
    }
}

