/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.items;

import io.github.thebusybiscuit.mobcapturer.MobCapturer;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import io.github.thebusybiscuit.mobcapturer.setup.ItemStacks;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MobCannon
extends SimpleSlimefunItem<ItemUseHandler> {
    @ParametersAreNonnullByDefault
    public MobCannon(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            if (this.consumeAmmo(e.getPlayer())) {
                Snowball projectile = (Snowball)e.getPlayer().launchProjectile(Snowball.class);
                projectile.setMetadata("mob_capturing_cannon", (MetadataValue)new FixedMetadataValue((Plugin)MobCapturer.getInstance(), (Object)e.getPlayer().getUniqueId()));
            }
        };
    }

    @ParametersAreNonnullByDefault
    private boolean consumeAmmo(Player p) {
        if (p.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        for (ItemStack item : p.getInventory()) {
            if (!ItemStacks.MOB_CAPTURING_PELLET.getItem().isItem(item)) continue;
            ItemUtils.consumeItem((ItemStack)item, (boolean)false);
            return true;
        }
        return false;
    }
}

