/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.MobAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Animals;

public class AnimalsAdapter<T extends Animals>
implements MobAdapter<T> {
    private final Class<T> entityClass;

    public AnimalsAdapter(@Nonnull Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = MobAdapter.super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Baby: " + String.valueOf(ChatColor.WHITE) + json.get("baby").getAsBoolean());
        return lore;
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull T entity) {
        JsonObject json = MobAdapter.super.saveData(entity);
        json.addProperty("baby", Boolean.valueOf(!entity.isAdult()));
        json.addProperty("_age", (Number)entity.getAge());
        json.addProperty("_ageLock", Boolean.valueOf(entity.getAgeLock()));
        json.addProperty("_breedable", Boolean.valueOf(entity.canBreed()));
        json.addProperty("_loveModeTicks", (Number)entity.getLoveModeTicks());
        return json;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(T entity, JsonObject json) {
        MobAdapter.super.apply(entity, json);
        entity.setAge(json.get("_age").getAsInt());
        entity.setLoveModeTicks(json.get("_loveModeTicks").getAsInt());
        entity.setAgeLock(json.get("_ageLock").getAsBoolean());
        entity.setBreed(json.get("_breedable").getAsBoolean());
    }

    @Override
    @Nonnull
    public Class<T> getEntityClass() {
        return this.entityClass;
    }
}

