/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AnimalsAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Hoglin;

public class ZoglinAdapter
extends AnimalsAdapter<Hoglin> {
    public ZoglinAdapter() {
        super(Hoglin.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Baby: " + String.valueOf(ChatColor.WHITE) + json.get("baby").getAsBoolean());
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Hoglin entity, JsonObject json) {
        super.apply(entity, json);
        entity.setAge(json.get("age").getAsInt());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Hoglin entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("age", (Number)entity.getAge());
        json.addProperty("baby", Boolean.valueOf(!entity.isAdult()));
        return json;
    }
}

