/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AbstractTameableAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.entity.Cat;

public class CatAdapter
extends AbstractTameableAdapter<Cat> {
    public CatAdapter() {
        super(Cat.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Variant: " + String.valueOf(ChatColor.WHITE) + ChatUtils.humanize((String)json.get("catType").getAsString()));
        if (!json.get("ownerUUID").isJsonNull()) {
            lore.add(String.valueOf(ChatColor.GRAY) + "Collar Color: " + String.valueOf(ChatColor.WHITE) + ChatUtils.humanize((String)json.get("collarColor").getAsString()));
            lore.add(String.valueOf(ChatColor.GRAY) + "Sitting: " + String.valueOf(ChatColor.WHITE) + json.get("sitting").getAsBoolean());
        }
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Cat entity, JsonObject json) {
        super.apply(entity, json);
        entity.setCatType(Cat.Type.valueOf((String)json.get("catType").getAsString()));
        entity.setSitting(json.get("sitting").getAsBoolean());
        entity.setCollarColor(DyeColor.valueOf((String)json.get("collarColor").getAsString()));
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Cat entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("catType", entity.getCatType().name());
        json.addProperty("sitting", Boolean.valueOf(entity.isSitting()));
        json.addProperty("collarColor", entity.getCollarColor().name());
        return json;
    }
}

