/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AnimalsAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Rabbit;

public class RabbitAdapter
extends AnimalsAdapter<Rabbit> {
    public RabbitAdapter() {
        super(Rabbit.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Variant: " + String.valueOf(ChatColor.WHITE) + ChatUtils.humanize((String)json.get("rabbitType").getAsString()));
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Rabbit entity, JsonObject json) {
        super.apply(entity, json);
        entity.setRabbitType(Rabbit.Type.valueOf((String)json.get("rabbitType").getAsString()));
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Rabbit entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("rabbitType", entity.getRabbitType().name());
        return json;
    }
}

