/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AbstractHumanoidAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.PigZombie;

public class ZombifiedPiglinAdapter
extends AbstractHumanoidAdapter<PigZombie> {
    public ZombifiedPiglinAdapter() {
        super(PigZombie.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Anger: " + String.valueOf(ChatColor.WHITE) + json.get("anger").getAsString());
        lore.add(String.valueOf(ChatColor.GRAY) + "Baby: " + String.valueOf(ChatColor.WHITE) + json.get("baby").getAsBoolean());
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(PigZombie entity, JsonObject json) {
        super.apply(entity, json);
        entity.setAnger(json.get("anger").getAsInt());
        entity.setAge(json.get("age").getAsInt());
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull PigZombie entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("anger", (Number)entity.getAnger());
        json.addProperty("age", (Number)entity.getAge());
        json.addProperty("baby", Boolean.valueOf(!entity.isAdult()));
        return json;
    }
}

