/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.ZombieAdapter;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.Nonnull;
import io.github.thebusybiscuit.mobcapturer.libs.annotation.ParametersAreNonnullByDefault;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;

public class ZombieVillagerAdapter
extends ZombieAdapter<ZombieVillager> {
    public ZombieVillagerAdapter() {
        super(ZombieVillager.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(String.valueOf(ChatColor.GRAY) + "Profession: " + String.valueOf(ChatColor.WHITE) + ChatUtils.humanize((String)json.get("profession").getAsString()));
        return lore;
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull ZombieVillager entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("profession", entity.getVillagerProfession().name());
        json.addProperty("conversionPlayer", entity.getConversionPlayer() == null ? null : entity.getConversionPlayer().getUniqueId().toString());
        return json;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(ZombieVillager entity, JsonObject json) {
        super.apply(entity, json);
        entity.setVillagerProfession(Villager.Profession.valueOf((String)json.get("profession").getAsString()));
        JsonElement player = json.get("conversionPlayer");
        if (!player.isJsonNull()) {
            entity.setConversionPlayer(Bukkit.getOfflinePlayer((UUID)UUID.fromString(player.getAsString())));
        }
    }
}

