/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.InventoryAdapter;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AnimalsAdapter;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Fox;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class FoxAdapter
extends AnimalsAdapter<Fox>
implements InventoryAdapter<Fox> {
    public FoxAdapter() {
        super(Fox.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Variant: " + ChatColor.WHITE + ChatUtils.humanize((String)json.get("foxType").getAsString()));
        if (json.get("crouching").getAsBoolean()) {
            lore.add(ChatColor.GRAY + "Crouching: " + ChatColor.WHITE + json.get("crouching").getAsBoolean());
        } else if (json.get("sitting").getAsBoolean()) {
            lore.add(ChatColor.GRAY + "Sitting: " + ChatColor.WHITE + json.get("sitting").getAsBoolean());
        } else if (json.get("sleeping").getAsBoolean()) {
            lore.add(ChatColor.GRAY + "Sleeping: " + ChatColor.WHITE + json.get("sleeping").getAsBoolean());
        }
        JsonElement firstElement = json.get("firstTrustedPlayerName");
        JsonElement secondElement = json.get("secondTrustedPlayerName");
        if (!firstElement.isJsonNull()) {
            if (secondElement.isJsonNull()) {
                lore.add(ChatColor.GRAY + "Trusted Player: " + ChatColor.WHITE + firstElement.getAsString());
            } else {
                lore.add(ChatColor.GRAY + "Trusted Players: " + ChatColor.WHITE + firstElement.getAsString() + ", " + secondElement.getAsString());
            }
        }
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Fox entity, JsonObject json) {
        OfflinePlayer player;
        super.apply(entity, json);
        entity.setFoxType(Fox.Type.valueOf((String)json.get("foxType").getAsString()));
        entity.setCrouching(json.get("crouching").getAsBoolean());
        entity.setSitting(json.get("sitting").getAsBoolean());
        entity.setSleeping(json.get("sleeping").getAsBoolean());
        JsonElement element = json.get("firstTrustedPlayerUUID");
        if (!element.isJsonNull()) {
            player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(element.getAsString()));
            entity.setFirstTrustedPlayer((AnimalTamer)player);
        }
        if (!(element = json.get("secondTrustedPlayerUUID")).isJsonNull()) {
            player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(element.getAsString()));
            entity.setSecondTrustedPlayer((AnimalTamer)player);
        }
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Fox entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("foxType", entity.getFoxType().name());
        json.addProperty("crouching", Boolean.valueOf(entity.isCrouching()));
        json.addProperty("sitting", Boolean.valueOf(entity.isSitting()));
        json.addProperty("sleeping", Boolean.valueOf(entity.isSleeping()));
        json.addProperty("firstTrustedPlayerUUID", entity.getFirstTrustedPlayer() == null ? null : entity.getFirstTrustedPlayer().getUniqueId().toString());
        json.addProperty("firstTrustedPlayerName", entity.getFirstTrustedPlayer() == null ? null : entity.getFirstTrustedPlayer().getName());
        json.addProperty("secondTrustedPlayerUUID", entity.getSecondTrustedPlayer() == null ? null : entity.getSecondTrustedPlayer().getUniqueId().toString());
        json.addProperty("secondTrustedPlayerName", entity.getSecondTrustedPlayer() == null ? null : entity.getSecondTrustedPlayer().getName());
        return json;
    }

    @Override
    @Nonnull
    public Map<String, ItemStack> saveInventory(@Nonnull Fox entity) {
        HashMap<String, ItemStack> inv = new HashMap<String, ItemStack>();
        EntityEquipment equipment = entity.getEquipment();
        if (equipment != null) {
            inv.put("mainHand", equipment.getItemInMainHand());
        }
        return inv;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void applyInventory(Fox entity, Map<String, ItemStack> inventory) {
        EntityEquipment equipment = entity.getEquipment();
        if (equipment != null) {
            equipment.setItemInMainHand(inventory.get("mainHand"));
        }
    }
}

