/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.listeners;

import io.github.thebusybiscuit.mobcapturer.MobCapturer;
import io.github.thebusybiscuit.mobcapturer.events.MobCaptureEvent;
import io.github.thebusybiscuit.mobcapturer.items.MobEgg;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PelletListener
implements Listener {
    private final MobCapturer plugin;

    public PelletListener(@Nonnull MobCapturer plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onProjectileHit(@Nonnull ProjectileHitEvent e) {
        Projectile projectile = e.getEntity();
        if (projectile instanceof Snowball) {
            Snowball pellet = (Snowball)projectile;
            projectile = e.getHitEntity();
            if (projectile instanceof LivingEntity) {
                Optional<ItemStack> optional;
                Player player;
                LivingEntity entity = (LivingEntity)projectile;
                if (pellet.hasMetadata("mob_capturing_cannon") && (projectile = pellet.getShooter()) instanceof Player && this.canCapture(player = (Player)projectile, entity) && (optional = this.capture(entity)).isPresent()) {
                    pellet.removeMetadata("mob_capturing_cannon", (Plugin)this.plugin);
                    entity.remove();
                    this.dropEgg(player, optional.get(), entity.getLocation());
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected boolean canCapture(Player p, LivingEntity entity) {
        if (!MobCapturer.getRegistry().getAdapters().containsKey(entity.getType())) {
            return false;
        }
        MobCaptureEvent captureEvent = new MobCaptureEvent(p, entity);
        Bukkit.getPluginManager().callEvent((Event)captureEvent);
        return !captureEvent.isCancelled();
    }

    @Nonnull
    protected Optional<ItemStack> capture(@Nonnull LivingEntity entity) {
        MobEgg<?> egg = MobCapturer.getRegistry().getAdapters().get(entity.getType());
        if (egg != null) {
            ItemStack item = egg.getEggItem(entity);
            return Optional.of(item);
        }
        return Optional.empty();
    }

    @ParametersAreNonnullByDefault
    protected void dropEgg(Player p, ItemStack item, Location loc) {
        Config config = MobCapturer.getRegistry().getConfig();
        if (config.getBoolean("options.mob-eggs-to-inventory")) {
            HashMap remainingItems = p.getInventory().addItem(new ItemStack[]{item});
            if (!remainingItems.isEmpty()) {
                for (ItemStack remainingItem : remainingItems.values()) {
                    p.getWorld().dropItemNaturally(p.getLocation(), remainingItem);
                }
            }
        } else {
            loc.getWorld().dropItemNaturally(loc, item);
        }
    }
}

