/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.listeners;

import io.github.thebusybiscuit.mobcapturer.MobCapturer;
import io.github.thebusybiscuit.mobcapturer.events.MobCaptureEvent;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class MobCaptureListener
implements Listener {
    private final MobCapturer plugin;

    public MobCaptureListener(@Nonnull MobCapturer plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onMobCapture(@Nonnull MobCaptureEvent e) {
        Config config = MobCapturer.getRegistry().getConfig();
        LivingEntity entity = e.getEntity();
        Player p = e.getPlayer();
        if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, entity.getLocation(), Interaction.ATTACK_ENTITY)) {
            e.setCancelled(true);
            return;
        }
        if (entity.getCustomName() != null) {
            if (!config.getBoolean("options.capture-named-mobs")) {
                e.setCancelled(true);
                return;
            }
            List ignoredMobNames = config.getStringList("options.ignored-mobs");
            if (ignoredMobNames.size() > 0) {
                String strippedEntityName = ChatColor.stripColor((String)entity.getCustomName());
                for (String ignoredMobName : ignoredMobNames) {
                    if (!ignoredMobName.equalsIgnoreCase(strippedEntityName)) continue;
                    e.setCancelled(true);
                    return;
                }
            }
        }
    }
}

