/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AnimalsAdapter;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Sniffer;

public class SnifferAdapter
extends AnimalsAdapter<Sniffer> {
    public SnifferAdapter() {
        super(Sniffer.class);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Sniffer entity, JsonObject json) {
        super.apply(entity, json);
        entity.setState(Sniffer.State.valueOf((String)json.get("state").getAsString()));
        JsonArray exploredLocations = json.get("exploredLocations").getAsJsonArray();
        for (JsonElement element : exploredLocations) {
            try {
                entity.addExploredLocation(this.deserializeLocation(element));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Sniffer entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("state", entity.getState().toString());
        JsonArray exploredLocations = new JsonArray();
        entity.getExploredLocations().forEach(location -> exploredLocations.add((JsonElement)this.serializeLocation((Location)location)));
        json.add("exploredLocations", (JsonElement)exploredLocations);
        return json;
    }

    @Nonnull
    private JsonObject serializeLocation(@Nonnull Location location) {
        JsonObject obj = new JsonObject();
        obj.addProperty("world", location.getWorld().getName());
        obj.addProperty("x", (Number)location.getX());
        obj.addProperty("y", (Number)location.getY());
        obj.addProperty("z", (Number)location.getZ());
        obj.addProperty("yaw", (Number)Float.valueOf(location.getYaw()));
        obj.addProperty("pitch", (Number)Float.valueOf(location.getPitch()));
        return obj;
    }

    @Nonnull
    private Location deserializeLocation(@Nonnull JsonElement element) {
        JsonPrimitive pitch;
        JsonPrimitive yaw;
        JsonPrimitive z;
        JsonPrimitive y;
        JsonPrimitive x;
        JsonPrimitive worldName;
        if (!(element instanceof JsonObject)) {
            throw new IllegalArgumentException("Not a JSON Object");
        }
        JsonObject obj = (JsonObject)element;
        JsonObject json = obj.getAsJsonObject();
        JsonElement worldObj = json.get("world");
        JsonElement xObj = json.get("x");
        JsonElement yObj = json.get("y");
        JsonElement zObj = json.get("z");
        JsonElement yawObj = json.get("yaw");
        JsonElement pitchObj = json.get("pitch");
        if (worldObj instanceof JsonPrimitive && (worldName = (JsonPrimitive)worldObj).isString() && xObj instanceof JsonPrimitive && (x = (JsonPrimitive)xObj).isNumber() && yObj instanceof JsonPrimitive && (y = (JsonPrimitive)yObj).isNumber() && zObj instanceof JsonPrimitive && (z = (JsonPrimitive)zObj).isNumber() && yawObj instanceof JsonPrimitive && (yaw = (JsonPrimitive)yawObj).isNumber() && pitchObj instanceof JsonPrimitive && (pitch = (JsonPrimitive)pitchObj).isNumber()) {
            World world = Bukkit.getWorld((String)worldName.getAsString());
            if (world == null) {
                throw new IllegalArgumentException("Unknown world: " + worldName.getAsString());
            }
            return new Location(world, x.getAsDouble(), y.getAsDouble(), z.getAsDouble(), yaw.getAsFloat(), pitch.getAsFloat());
        }
        throw new IllegalArgumentException("Malformed Location JSON");
    }
}

