/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.mobs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.mobs.AnimalsAdapter;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Tameable;

public class TameableAdapter<T extends Animals & Tameable>
extends AnimalsAdapter<T> {
    public TameableAdapter(Class<T> entityClass) {
        super(entityClass);
    }

    @Override
    public List<String> getLore(JsonObject json) {
        List<String> lore = super.getLore(json);
        JsonElement element = json.get("ownerName");
        if (!element.isJsonNull()) {
            lore.add(ChatColor.GRAY + "Owner: " + ChatColor.RESET + element.getAsString());
        }
        return lore;
    }

    @Override
    public JsonObject save(T entity) {
        JsonObject json = super.save(entity);
        json.addProperty("ownerUUID", ((Tameable)entity).getOwner() == null ? null : ((Tameable)entity).getOwner().getUniqueId().toString());
        json.addProperty("ownerName", ((Tameable)entity).getOwner() == null ? null : ((Tameable)entity).getOwner().getName());
        return json;
    }

    @Override
    public void apply(T entity, JsonObject json) {
        super.apply(entity, json);
        JsonElement element = json.get("ownerUUID");
        if (!element.isJsonNull()) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(element.getAsString()));
            ((Tameable)entity).setOwner((AnimalTamer)player);
        }
    }
}

