/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.mobs.AnimalsAdapter;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.entity.Sheep;

public class SheepAdapter
extends AnimalsAdapter<Sheep> {
    public SheepAdapter() {
        super(Sheep.class);
    }

    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = super.getLore(json);
        lore.add(ChatColor.GRAY + "Color: " + ChatColor.WHITE + ChatUtils.humanize((String)json.get("woolColor").getAsString()));
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(Sheep entity, JsonObject json) {
        super.apply(entity, json);
        entity.setSheared(json.get("sheared").getAsBoolean());
        entity.setColor(DyeColor.valueOf((String)json.get("woolColor").getAsString()));
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull Sheep entity) {
        JsonObject json = super.saveData(entity);
        json.addProperty("sheared", Boolean.valueOf(entity.isSheared()));
        json.addProperty("woolColor", entity.getColor().name());
        return json;
    }
}

