/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.mobcapturer.adapters.mobs;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.mobcapturer.adapters.MobAdapter;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.entity.TropicalFish;

public class TropicalFishAdapter
implements MobAdapter<TropicalFish> {
    @Override
    @Nonnull
    public List<String> getLore(@Nonnull JsonObject json) {
        List<String> lore = MobAdapter.super.getLore(json);
        lore.add(ChatColor.GRAY + "Base Color: " + ChatColor.WHITE + ChatUtils.humanize((String)json.get("baseColor").getAsString()));
        lore.add(ChatColor.GRAY + "Pattern: " + ChatColor.WHITE + ChatUtils.humanize((String)json.get("pattern").getAsString()));
        lore.add(ChatColor.GRAY + "Pattern Color: " + ChatColor.WHITE + ChatUtils.humanize((String)json.get("patternColor").getAsString()));
        return lore;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(TropicalFish entity, JsonObject json) {
        MobAdapter.super.apply(entity, json);
        entity.setBodyColor(DyeColor.valueOf((String)json.get("baseColor").getAsString()));
        entity.setPattern(TropicalFish.Pattern.valueOf((String)json.get("pattern").getAsString()));
        entity.setPatternColor(DyeColor.valueOf((String)json.get("patternColor").getAsString()));
    }

    @Override
    @Nonnull
    public JsonObject saveData(@Nonnull TropicalFish entity) {
        JsonObject json = MobAdapter.super.saveData(entity);
        json.addProperty("baseColor", entity.getBodyColor().name());
        json.addProperty("pattern", entity.getPattern().name());
        json.addProperty("patternColor", entity.getPatternColor().name());
        return json;
    }

    @Override
    @Nonnull
    public Class<TropicalFish> getEntityClass() {
        return TropicalFish.class;
    }
}

